/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.ReturnException;
import org.jruby.truffle.language.control.ReturnID;

public class CallPrimitiveNode
extends RubyNode {
    @Node.Child
    private RubyNode primitive;
    private final ReturnID returnID;
    private final ConditionProfile failedProfile = ConditionProfile.createBinaryProfile();

    public CallPrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode primitive, ReturnID returnID) {
        super(context, sourceSection);
        this.primitive = primitive;
        this.returnID = returnID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.primitive.execute(frame);
        if (this.failedProfile.profile(value == null)) {
            return this.nil();
        }
        throw new ReturnException(this.returnID, value);
    }
}

