/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.method;

import org.jruby.runtime.Visibility;
import org.jruby.truffle.language.methods.InternalMethod;

public abstract class MethodFilter {
    public static final MethodFilter PUBLIC = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PUBLIC;
        }
    };
    public static final MethodFilter PUBLIC_PROTECTED = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PUBLIC || method.getVisibility() == Visibility.PROTECTED;
        }
    };
    public static final MethodFilter PROTECTED = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PROTECTED;
        }
    };
    public static final MethodFilter PRIVATE = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PRIVATE;
        }
    };

    private MethodFilter() {
    }

    public abstract boolean filter(InternalMethod var1);

    public static MethodFilter by(Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return PUBLIC;
            }
            case PROTECTED: {
                return PROTECTED;
            }
            case PRIVATE: {
                return PRIVATE;
            }
        }
        throw new IllegalArgumentException("unsupported visibility: " + visibility);
    }
}

