/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArraySliceNode
extends RubyNode {
    final int from;
    final int to;

    public ArraySliceNode(RubyContext context, SourceSection sourceSection, int from, int to) {
        super(context, sourceSection);
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject sliceNull(DynamicObject array) {
        return ArrayHelpers.createArray(this.getContext(), null, 0);
    }

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject readInBounds(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile emptyArray) {
        int to = Layouts.ARRAY.getSize(array) + this.to;
        if (emptyArray.profile(this.from >= to)) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }
        Object store = strategy.newMirror(array).extractRange(this.from, to).getArray();
        return ArrayHelpers.createArray(this.getContext(), store, to - this.from);
    }
}

