/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.unpack;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.SharedTreeBuilder;
import org.jruby.truffle.core.format.control.AdvanceSourcePositionNode;
import org.jruby.truffle.core.format.control.ReverseSourcePositionNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.SetSourcePositionNode;
import org.jruby.truffle.core.format.convert.BytesToInteger16BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger16LittleNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger32BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger32LittleNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger64BigNodeGen;
import org.jruby.truffle.core.format.convert.BytesToInteger64LittleNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretAsUnsignedNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretByteAsIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretIntegerAsFloatNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretLongAsDoubleNodeGen;
import org.jruby.truffle.core.format.pack.PackBaseListener;
import org.jruby.truffle.core.format.pack.PackParser;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.bytes.ReadBERNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBase64StringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBinaryStringNode;
import org.jruby.truffle.core.format.read.bytes.ReadBinaryStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBitStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadByteNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadBytesNode;
import org.jruby.truffle.core.format.read.bytes.ReadBytesNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadHexStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadMIMEStringNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadUTF8CharacterNodeGen;
import org.jruby.truffle.core.format.read.bytes.ReadUUStringNodeGen;
import org.jruby.truffle.core.format.write.OutputNode;
import org.jruby.truffle.core.format.write.array.WriteValueNode;
import org.jruby.truffle.core.format.write.array.WriteValueNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class UnpackTreeBuilder
extends PackBaseListener {
    private final RubyContext context;
    private final Node currentNode;
    private final SharedTreeBuilder sharedTreeBuilder;
    private final Deque<List<FormatNode>> sequenceStack = new ArrayDeque<List<FormatNode>>();

    public UnpackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.sharedTreeBuilder = new SharedTreeBuilder(context);
        this.pushSequence();
    }

    @Override
    public void enterSequence(PackParser.SequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSequence(PackParser.SequenceContext ctx) {
        List<FormatNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(this.context, sequence.toArray(new FormatNode[sequence.size()])));
    }

    @Override
    public void exitInt8(PackParser.Int8Context ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, new OutputNode(), ReinterpretByteAsIntegerNodeGen.create(this.context, true, ReadByteNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitUint8(PackParser.Uint8Context ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, new OutputNode(), ReinterpretByteAsIntegerNodeGen.create(this.context, false, ReadByteNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitInt16Little(PackParser.Int16LittleContext ctx) {
        this.appendIntegerNode(16, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt16Big(PackParser.Int16BigContext ctx) {
        this.appendIntegerNode(16, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt16Native(PackParser.Int16NativeContext ctx) {
        this.appendIntegerNode(16, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint16Little(PackParser.Uint16LittleContext ctx) {
        this.appendIntegerNode(16, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint16Big(PackParser.Uint16BigContext ctx) {
        this.appendIntegerNode(16, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint16Native(PackParser.Uint16NativeContext ctx) {
        this.appendIntegerNode(16, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    @Override
    public void exitInt32Little(PackParser.Int32LittleContext ctx) {
        this.appendIntegerNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt32Big(PackParser.Int32BigContext ctx) {
        this.appendIntegerNode(32, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt32Native(PackParser.Int32NativeContext ctx) {
        this.appendIntegerNode(32, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint32Little(PackParser.Uint32LittleContext ctx) {
        this.appendIntegerNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint32Big(PackParser.Uint32BigContext ctx) {
        this.appendIntegerNode(32, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint32Native(PackParser.Uint32NativeContext ctx) {
        this.appendIntegerNode(32, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    @Override
    public void exitInt64Little(PackParser.Int64LittleContext ctx) {
        this.appendIntegerNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt64Big(PackParser.Int64BigContext ctx) {
        this.appendIntegerNode(64, ByteOrder.BIG_ENDIAN, ctx.count(), true);
    }

    @Override
    public void exitInt64Native(PackParser.Int64NativeContext ctx) {
        this.appendIntegerNode(64, ByteOrder.nativeOrder(), ctx.count(), true);
    }

    @Override
    public void exitUint64Little(PackParser.Uint64LittleContext ctx) {
        this.appendIntegerNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint64Big(PackParser.Uint64BigContext ctx) {
        this.appendIntegerNode(64, ByteOrder.BIG_ENDIAN, ctx.count(), false);
    }

    @Override
    public void exitUint64Native(PackParser.Uint64NativeContext ctx) {
        this.appendIntegerNode(64, ByteOrder.nativeOrder(), ctx.count(), false);
    }

    @Override
    public void exitUtf8Character(PackParser.Utf8CharacterContext ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, new OutputNode(), ReadUTF8CharacterNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitBerInteger(PackParser.BerIntegerContext ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteValueNodeGen.create(this.context, new OutputNode(), ReadBERNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitF64Native(PackParser.F64NativeContext ctx) {
        this.appendFloatNode(64, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitF32Native(PackParser.F32NativeContext ctx) {
        this.appendFloatNode(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitF64Little(PackParser.F64LittleContext ctx) {
        this.appendFloatNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitF32Little(PackParser.F32LittleContext ctx) {
        this.appendFloatNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitF64Big(PackParser.F64BigContext ctx) {
        this.appendFloatNode(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitF32Big(PackParser.F32BigContext ctx) {
        this.appendFloatNode(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBinaryStringSpacePadded(PackParser.BinaryStringSpacePaddedContext ctx) {
        ReadBinaryStringNode readNode;
        SourceNode source = new SourceNode();
        if (ctx.count() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, false, false, 1, true, true, false, source);
        } else if (ctx.count().INT() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, true, false, -1, true, true, false, source);
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            readNode = ReadBinaryStringNodeGen.create(this.context, false, false, count, true, true, false, source);
        }
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), readNode));
    }

    @Override
    public void exitBinaryStringNullPadded(PackParser.BinaryStringNullPaddedContext ctx) {
        ReadBinaryStringNode readNode;
        SourceNode source = new SourceNode();
        if (ctx.count() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, false, false, 1, false, false, false, source);
        } else if (ctx.count().INT() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, true, false, -1, false, false, false, source);
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            readNode = ReadBinaryStringNodeGen.create(this.context, false, false, count, false, false, false, source);
        }
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), readNode));
    }

    @Override
    public void exitBinaryStringNullStar(PackParser.BinaryStringNullStarContext ctx) {
        ReadBinaryStringNode readNode;
        SourceNode source = new SourceNode();
        if (ctx.count() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, false, true, 1, false, true, true, source);
        } else if (ctx.count().INT() == null) {
            readNode = ReadBinaryStringNodeGen.create(this.context, true, true, -1, false, true, true, source);
        } else {
            int count = Integer.parseInt(ctx.count().INT().getSymbol().getText());
            readNode = ReadBinaryStringNodeGen.create(this.context, false, false, count, false, true, true, source);
        }
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), readNode));
    }

    @Override
    public void exitBitStringMSBFirst(PackParser.BitStringMSBFirstContext ctx) {
        this.bitString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBitStringMSBLast(PackParser.BitStringMSBLastContext ctx) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringHighFirst(PackParser.HexStringHighFirstContext ctx) {
        this.hexString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringLowFirst(PackParser.HexStringLowFirstContext ctx) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUuString(PackParser.UuStringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), ReadUUStringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitMimeString(PackParser.MimeStringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), ReadMIMEStringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitBase64String(PackParser.Base64StringContext ctx) {
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), ReadBase64StringNodeGen.create(this.context, new SourceNode())));
    }

    @Override
    public void exitAt(PackParser.AtContext ctx) {
        int position;
        if (ctx.count() == null) {
            position = 0;
        } else {
            if (ctx.count() != null && ctx.count().INT() == null) {
                return;
            }
            position = Integer.parseInt(ctx.count().INT().getText());
        }
        this.appendNode(new SetSourcePositionNode(this.context, position));
    }

    @Override
    public void exitBack(PackParser.BackContext ctx) {
        if (ctx.count() != null && ctx.count().INT() == null) {
            this.appendNode(new ReverseSourcePositionNode(this.context, true));
        } else if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), new ReverseSourcePositionNode(this.context, false)));
        }
    }

    @Override
    public void exitNullByte(PackParser.NullByteContext ctx) {
        if (ctx.count() != null && ctx.count().INT() == null) {
            this.appendNode(new AdvanceSourcePositionNode(this.context, true));
        } else if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), new AdvanceSourcePositionNode(this.context, false)));
        }
    }

    @Override
    public void enterSubSequence(PackParser.SubSequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSubSequence(PackParser.SubSequenceContext ctx) {
        this.appendNode(this.sharedTreeBuilder.finishSubSequence(this.sequenceStack, ctx));
    }

    @Override
    public void exitErrorDisallowedNative(PackParser.ErrorDisallowedNativeContext ctx) {
        throw new RaiseException(this.context.getCoreExceptions().argumentError("'" + ctx.NATIVE().getText() + "' allowed only after types sSiIlLqQ", this.currentNode));
    }

    public FormatNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(FormatNode node) {
        this.sequenceStack.peek().add(node);
    }

    private boolean consumePartial(PackParser.CountContext ctx) {
        return ctx != null && ctx.INT() == null;
    }

    private void appendIntegerNode(int size, ByteOrder byteOrder, PackParser.CountContext count, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(this.context, size / 8, this.consumePartial(count), new SourceNode());
        FormatNode convertNode = this.createIntegerDecodeNode(size, byteOrder, signed, readNode);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, WriteValueNodeGen.create(this.context, new OutputNode(), convertNode)));
    }

    private void appendFloatNode(int size, ByteOrder byteOrder, PackParser.CountContext count) {
        FormatNode decodeNode;
        FormatNode readNode = this.readBytesAsInteger(size, byteOrder, this.consumePartial(count), true);
        switch (size) {
            case 32: {
                decodeNode = ReinterpretIntegerAsFloatNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                decodeNode = ReinterpretLongAsDoubleNodeGen.create(this.context, readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        WriteValueNode writeNode = WriteValueNodeGen.create(this.context, new OutputNode(), decodeNode);
        this.appendNode(this.sharedTreeBuilder.applyCount(count, writeNode));
    }

    private FormatNode readBytesAsInteger(int size, ByteOrder byteOrder, boolean consumePartial, boolean signed) {
        ReadBytesNode readNode = ReadBytesNodeGen.create(this.context, size / 8, consumePartial, new SourceNode());
        return this.createIntegerDecodeNode(size, byteOrder, signed, readNode);
    }

    private FormatNode createIntegerDecodeNode(int size, ByteOrder byteOrder, boolean signed, FormatNode readNode) {
        FormatNode decodeNode;
        switch (size) {
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger16LittleNodeGen.create(this.context, readNode);
                    break;
                }
                decodeNode = BytesToInteger16BigNodeGen.create(this.context, readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger32LittleNodeGen.create(this.context, readNode);
                    break;
                }
                decodeNode = BytesToInteger32BigNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    decodeNode = BytesToInteger64LittleNodeGen.create(this.context, readNode);
                    break;
                }
                decodeNode = BytesToInteger64BigNodeGen.create(this.context, readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!signed) {
            decodeNode = ReinterpretAsUnsignedNodeGen.create(this.context, decodeNode);
        }
        return decodeNode;
    }

    private void bitString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(ctx);
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), ReadBitStringNodeGen.create(this.context, byteOrder, starLength.isStar(), starLength.getLength(), new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(ctx);
        this.appendNode(WriteValueNodeGen.create(this.context, new OutputNode(), ReadHexStringNodeGen.create(this.context, byteOrder, starLength.isStar(), starLength.getLength(), new SourceNode())));
    }
}

