/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.klass;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.module.ModuleFields;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="Class")
public abstract class ClassNodes {
    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createClassClass(RubyContext context) {
        ModuleFields model = new ModuleFields(context, null, "Class");
        model.setFullName(model.givenBaseName);
        DynamicObjectFactory tempFactory = Layouts.CLASS.createClassShape(null, null);
        DynamicObject rubyClass = Layouts.CLASS.createClass(tempFactory, model, false, null, null, null);
        Layouts.BASIC_OBJECT.setLogicalClass(rubyClass, rubyClass);
        Layouts.BASIC_OBJECT.setMetaClass(rubyClass, rubyClass);
        assert (RubyGuards.isRubyModule(rubyClass));
        assert (RubyGuards.isRubyClass(rubyClass));
        model.rubyModuleObject = rubyClass;
        DynamicObjectFactory instanceFactory = Layouts.CLASS.createClassShape(rubyClass, rubyClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(rubyClass, instanceFactory);
        assert (RubyGuards.isRubyModule(rubyClass));
        assert (RubyGuards.isRubyClass(rubyClass));
        assert (Layouts.MODULE.getFields(rubyClass) == model);
        assert (Layouts.BASIC_OBJECT.getLogicalClass(rubyClass) == rubyClass);
        assert (Layouts.BASIC_OBJECT.getMetaClass(rubyClass) == rubyClass);
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createBootClass(RubyContext context, DynamicObject classClass, DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyClass(classClass));
        assert (superclass == null || RubyGuards.isRubyClass(superclass));
        ModuleFields model = new ModuleFields(context, null, name);
        DynamicObject rubyClass = Layouts.CLASS.createClass(Layouts.CLASS.getInstanceFactory(classClass), model, false, null, null, null);
        assert (RubyGuards.isRubyClass(rubyClass)) : classClass.getShape().getObjectType().getClass();
        assert (RubyGuards.isRubyModule(rubyClass)) : classClass.getShape().getObjectType().getClass();
        model.rubyModuleObject = rubyClass;
        ModuleFields fields = Layouts.MODULE.getFields(rubyClass);
        if (model.lexicalParent == null) {
            fields.setFullName(fields.givenBaseName);
        } else {
            fields.getAdoptedByLexicalParent(context, model.lexicalParent, model.givenBaseName, null);
        }
        if (superclass != null) {
            assert (RubyGuards.isRubyClass(superclass));
            assert (RubyGuards.isRubyClass(rubyClass));
            fields.parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
            Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
            Layouts.CLASS.setSuperclass(rubyClass, superclass);
            fields.newVersion();
        }
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createSingletonClassOfObject(RubyContext context, DynamicObject superclass, DynamicObject attached, String name) {
        assert (RubyGuards.isRubyClass(superclass));
        assert (attached != null);
        return ClassNodes.ensureItHasSingletonClassCreated(context, ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(superclass), null, superclass, name, true, attached, true));
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createInitializedRubyClass(RubyContext context, DynamicObject lexicalParent, DynamicObject superclass, String name) {
        DynamicObject rubyClass = ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(superclass), lexicalParent, superclass, name, false, null, true);
        ClassNodes.ensureItHasSingletonClassCreated(context, rubyClass);
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createRubyClass(RubyContext context, DynamicObject classClass, DynamicObject lexicalParent, DynamicObject superclass, String name, boolean isSingleton, DynamicObject attached, boolean initialized) {
        assert (superclass == null || RubyGuards.isRubyClass(superclass));
        ModuleFields model = new ModuleFields(context, lexicalParent, name);
        DynamicObject rubyClass = Layouts.CLASS.createClass(Layouts.CLASS.getInstanceFactory(classClass), model, isSingleton, attached, null, initialized ? superclass : null);
        assert (RubyGuards.isRubyClass(rubyClass)) : classClass.getShape().getObjectType().getClass();
        assert (RubyGuards.isRubyModule(rubyClass)) : classClass.getShape().getObjectType().getClass();
        model.rubyModuleObject = rubyClass;
        ModuleFields fields = Layouts.MODULE.getFields(rubyClass);
        if (model.lexicalParent != null) {
            fields.getAdoptedByLexicalParent(context, model.lexicalParent, model.givenBaseName, null);
        } else if (fields.givenBaseName != null) {
            fields.setFullName(fields.givenBaseName);
        }
        if (superclass != null) {
            fields.parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
            Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
            fields.newVersion();
        }
        if (!isSingleton) {
            ClassNodes.setInstanceFactory(rubyClass, superclass);
        }
        return rubyClass;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initialize(RubyContext context, DynamicObject rubyClass, DynamicObject superclass) {
        assert (RubyGuards.isRubyClass(superclass));
        assert (!Layouts.CLASS.getIsSingleton(rubyClass)) : "Singleton classes can only be created internally";
        Layouts.MODULE.getFields((DynamicObject)rubyClass).parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
        Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
        Layouts.MODULE.getFields(rubyClass).newVersion();
        ClassNodes.ensureItHasSingletonClassCreated(context, rubyClass);
        ClassNodes.setInstanceFactory(rubyClass, superclass);
        Layouts.CLASS.setSuperclass(rubyClass, superclass);
    }

    public static void setInstanceFactory(DynamicObject rubyClass, DynamicObject baseClass) {
        assert (!Layouts.CLASS.getIsSingleton(rubyClass)) : "Singleton classes cannot be instantiated";
        DynamicObjectFactory factory = Layouts.CLASS.getInstanceFactory(baseClass);
        factory = Layouts.BASIC_OBJECT.setLogicalClass(factory, rubyClass);
        factory = Layouts.BASIC_OBJECT.setMetaClass(factory, rubyClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(rubyClass, factory);
    }

    private static DynamicObject ensureItHasSingletonClassCreated(RubyContext context, DynamicObject rubyClass) {
        ClassNodes.getLazyCreatedSingletonClass(context, rubyClass);
        return rubyClass;
    }

    public static DynamicObject getSingletonClass(RubyContext context, DynamicObject rubyClass) {
        return ClassNodes.ensureItHasSingletonClassCreated(context, ClassNodes.getLazyCreatedSingletonClass(context, rubyClass));
    }

    public static DynamicObject getSingletonClassOrNull(RubyContext context, DynamicObject rubyClass) {
        if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(rubyClass))) {
            return ClassNodes.ensureItHasSingletonClassCreated(context, Layouts.BASIC_OBJECT.getMetaClass(rubyClass));
        }
        return null;
    }

    private static DynamicObject getLazyCreatedSingletonClass(RubyContext context, DynamicObject rubyClass) {
        if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(rubyClass))) {
            return Layouts.BASIC_OBJECT.getMetaClass(rubyClass);
        }
        return ClassNodes.createSingletonClass(context, rubyClass);
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createSingletonClass(RubyContext context, DynamicObject rubyClass) {
        DynamicObject singletonSuperclass = ClassNodes.getSuperClass(rubyClass) == null ? Layouts.BASIC_OBJECT.getLogicalClass(rubyClass) : ClassNodes.getLazyCreatedSingletonClass(context, ClassNodes.getSuperClass(rubyClass));
        String name = StringUtils.format("#<Class:%s>", Layouts.MODULE.getFields(rubyClass).getName());
        Layouts.BASIC_OBJECT.setMetaClass(rubyClass, ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(rubyClass), null, singletonSuperclass, name, true, rubyClass, true));
        return Layouts.BASIC_OBJECT.getMetaClass(rubyClass);
    }

    public static DynamicObject getSuperClass(DynamicObject rubyClass) {
        CompilerAsserts.neverPartOfCompilation();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(rubyClass).parentAncestors()) {
            if (!RubyGuards.isRubyClass(ancestor) || ancestor == rubyClass) continue;
            return ancestor;
        }
        return null;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateConstructorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject classClass) {
            assert (classClass == this.coreLibrary().getClassClass()) : "Subclasses of class Class are forbidden in Ruby";
            return ClassNodes.createRubyClass(this.getContext(), this.coreLibrary().getClassClass(), null, this.coreLibrary().getObjectClass(), null, false, null, false);
        }
    }

    @CoreMethod(names={"superclass"})
    public static abstract class SuperClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"rubyClass == cachedRubyCLass", "cachedSuperclass != null"}, limit="getCacheLimit()")
        public Object getSuperClass(DynamicObject rubyClass, @Cached(value="rubyClass") DynamicObject cachedRubyCLass, @Cached(value="fastLookUp(cachedRubyCLass)") DynamicObject cachedSuperclass) {
            return cachedSuperclass;
        }

        @Specialization(contains={"getSuperClass"})
        DynamicObject getSuperClassUncached(DynamicObject rubyClass, @Cached(value="create()") BranchProfile errorProfile) {
            DynamicObject superclass = this.fastLookUp(rubyClass);
            if (superclass != null) {
                return superclass;
            }
            errorProfile.enter();
            throw new RaiseException(this.getContext().getCoreExceptions().typeError("uninitialized class", this));
        }

        protected DynamicObject fastLookUp(DynamicObject rubyClass) {
            return Layouts.CLASS.getSuperclass(rubyClass);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().CLASS_CACHE;
        }
    }

    @CoreMethod(names={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class InheritedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject inherited(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ModuleNodes.InitializeNode moduleInitializeNode;
        @Node.Child
        private CallDispatchHeadNode inheritedNode;

        void triggerInheritedHook(VirtualFrame frame, DynamicObject subClass, DynamicObject superClass) {
            if (this.inheritedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.inheritedNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            this.inheritedNode.call(frame, superClass, "inherited", subClass);
        }

        void moduleInitialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject block) {
            if (this.moduleInitializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.moduleInitializeNode = this.insert(ModuleNodesFactory.InitializeNodeFactory.create(null));
            }
            this.moduleInitializeNode.executeInitialize(frame, rubyClass, block);
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, NotProvided superclass, NotProvided block) {
            return this.initializeGeneralWithoutBlock(frame, rubyClass, this.coreLibrary().getObjectClass());
        }

        @Specialization(guards={"isRubyClass(superclass)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, NotProvided block) {
            return this.initializeGeneralWithoutBlock(frame, rubyClass, superclass);
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, NotProvided superclass, DynamicObject block) {
            return this.initializeGeneralWithBlock(frame, rubyClass, this.coreLibrary().getObjectClass(), block);
        }

        @Specialization(guards={"isRubyClass(superclass)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, DynamicObject block) {
            return this.initializeGeneralWithBlock(frame, rubyClass, superclass, block);
        }

        private DynamicObject initializeGeneralWithoutBlock(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass) {
            assert (RubyGuards.isRubyClass(rubyClass));
            assert (RubyGuards.isRubyClass(superclass));
            ClassNodes.initialize(this.getContext(), rubyClass, superclass);
            this.triggerInheritedHook(frame, rubyClass, superclass);
            return rubyClass;
        }

        private DynamicObject initializeGeneralWithBlock(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, DynamicObject block) {
            assert (RubyGuards.isRubyClass(superclass));
            ClassNodes.initialize(this.getContext(), rubyClass, superclass);
            this.triggerInheritedHook(frame, rubyClass, superclass);
            this.moduleInitialize(frame, rubyClass, block);
            return rubyClass;
        }
    }

    @CoreMethod(names={"new"}, needsBlock=true, rest=true)
    public static abstract class NewNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode allocateNode;
        @Node.Child
        private CallDispatchHeadNode initialize;

        public NewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object newInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, NotProvided block) {
            return this.doNewInstance(frame, rubyClass, args, null);
        }

        @Specialization
        public Object newInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, DynamicObject block) {
            return this.doNewInstance(frame, rubyClass, args, block);
        }

        private Object doNewInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, DynamicObject block) {
            Object instance = this.allocateNode.call(frame, rubyClass, "allocate", new Object[0]);
            this.initialize.callWithBlock(frame, instance, "initialize", block, args);
            return instance;
        }
    }
}

