/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LazyRope;
import org.jruby.truffle.core.rope.Rope;

public class LazyIntRope
extends LazyRope {
    final int value;

    public LazyIntRope(int value) {
        this(value, (Encoding)USASCIIEncoding.INSTANCE, LazyIntRope.length(value));
    }

    protected LazyIntRope(int value, Encoding encoding, int length) {
        super(encoding, length, length);
        this.value = value;
        assert (Integer.toString(value).length() == length);
    }

    private static int length(int value) {
        int sign;
        if (value < 0) {
            if (value <= -1000000000) {
                return 11;
            }
            value = -value;
            sign = 1;
        } else {
            sign = 0;
        }
        return sign + ((double)value < 100000.0 ? ((double)value < 100.0 ? ((double)value < 10.0 ? 1 : 2) : ((double)value < 1000.0 ? 3 : ((double)value < 10000.0 ? 4 : 5))) : ((double)value < 1.0E7 ? ((double)value < 1000000.0 ? 6 : 7) : ((double)value < 1.0E8 ? 8 : ((double)value < 1.0E9 ? 9 : 10))));
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new LazyIntRope(this.value, newEncoding, LazyIntRope.length(this.value));
    }

    @Override
    public byte[] fulfill() {
        if (this.bytes == null) {
            this.bytes = Integer.toString(this.value).getBytes(StandardCharsets.US_ASCII);
        }
        return this.bytes;
    }

    public int getValue() {
        return this.value;
    }
}

