/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.util.Random;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.RubyRandom;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.RopeOperations;

public abstract class RandomizerPrimitiveNodes {
    @CompilerDirectives.TruffleBoundary
    private static int randomInt(org.jruby.util.Random random) {
        return random.genrandInt32();
    }

    @Primitive(name="randomizer_bytes", lowerFixnum={1})
    public static abstract class RandomizerBytesPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject genRandBytes(DynamicObject randomizer, int length) {
            int i;
            int r;
            org.jruby.util.Random random = Layouts.RANDOMIZER.getRandom(randomizer);
            byte[] bytes = new byte[length];
            int idx = 0;
            while (length >= 4) {
                r = random.genrandInt32();
                for (i = 0; i < 4; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
                length -= 4;
            }
            if (length > 0) {
                r = random.genrandInt32();
                for (i = 0; i < length; ++i) {
                    bytes[idx++] = (byte)(r & 0xFF);
                    r >>>= 8;
                }
            }
            return this.createString(RopeOperations.create(bytes, (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_UNKNOWN));
        }
    }

    @Primitive(name="randomizer_gen_seed")
    public static abstract class RandomizerGenSeedPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject randomizerGenSeed(DynamicObject randomizerClass) {
            BigInteger seed = RubyRandom.randomSeedBigInteger((Random)this.getContext().getJRubyRuntime().getRandom());
            return this.createBignum(seed);
        }
    }

    @Primitive(name="randomizer_rand_int")
    public static abstract class RandomizerRandIntPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public int randomizerRandInt(DynamicObject randomizer, int limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return (int)RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @Specialization
        public long randomizerRandInt(DynamicObject randomizer, long limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @CompilerDirectives.TruffleBoundary
        protected static long randInt(org.jruby.util.Random r, long limit) {
            return RubyRandom.randLimitedFixnumInner((org.jruby.util.Random)r, (long)limit);
        }
    }

    @Primitive(name="randomizer_rand_float")
    public static abstract class RandomizerRandFloatPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public double randomizerRandFloat(DynamicObject randomizer) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            int a = RandomizerPrimitiveNodes.randomInt(r) >>> 5;
            int b = RandomizerPrimitiveNodes.randomInt(r) >>> 6;
            return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        }
    }

    @Primitive(name="randomizer_seed")
    public static abstract class RandomizerSeedPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyBignum(seed)"})
        public DynamicObject randomizerSeed(DynamicObject randomizer, DynamicObject seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromBigInteger(Layouts.BIGNUM.getValue(seed)));
            return randomizer;
        }

        @Specialization
        public DynamicObject randomizerSeed(DynamicObject randomizer, long seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromLong(seed));
            return randomizer;
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromBigInteger(BigInteger seed) {
            return RubyRandom.RandomType.randomFromBigInteger((BigInteger)seed);
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromLong(long seed) {
            return RubyRandom.RandomType.randomFromLong((long)seed);
        }
    }

    @Primitive(name="randomizer_allocate", needsSelf=false)
    public static abstract class RandomizerAllocatePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject randomizerAllocate() {
            return Layouts.RANDOMIZER.createRandomizer(this.coreLibrary().getRandomizerFactory(), new org.jruby.util.Random());
        }
    }
}

