/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import jnr.posix.FileStat;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.StatLayout;

@GeneratedBy(value=StatLayout.class)
public class StatLayoutImpl
extends BasicObjectLayoutImpl
implements StatLayout {
    public static final StatLayout INSTANCE = new StatLayoutImpl();
    protected static final Shape.Allocator STAT_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey STAT_IDENTIFIER = new HiddenKey("stat");
    protected static final Property STAT_PROPERTY = Property.create(STAT_IDENTIFIER, STAT_ALLOCATOR.locationForType(FileStat.class), 0);

    protected StatLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createStatShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new StatType(logicalClass, metaClass)).addProperty(STAT_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createStat(DynamicObjectFactory factory, FileStat stat) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (StatLayoutImpl.createsStat(factory));
        assert (factory.getShape().hasProperty(STAT_IDENTIFIER));
        return factory.newInstance(stat);
    }

    private static boolean isStat(DynamicObject object) {
        return StatLayoutImpl.isStat(object.getShape().getObjectType());
    }

    private static boolean isStat(ObjectType objectType) {
        return objectType instanceof StatType;
    }

    private static boolean createsStat(DynamicObjectFactory factory) {
        return StatLayoutImpl.isStat(factory.getShape().getObjectType());
    }

    @Override
    public FileStat getStat(DynamicObject object) {
        assert (StatLayoutImpl.isStat(object));
        assert (object.getShape().hasProperty(STAT_IDENTIFIER));
        return (FileStat)STAT_PROPERTY.get(object, StatLayoutImpl.isStat(object));
    }

    @Override
    public void setStat(DynamicObject object, FileStat value) {
        assert (StatLayoutImpl.isStat(object));
        assert (object.getShape().hasProperty(STAT_IDENTIFIER));
        try {
            STAT_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class StatType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public StatType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public StatType setLogicalClass(DynamicObject logicalClass) {
            return new StatType(logicalClass, this.metaClass);
        }

        @Override
        public StatType setMetaClass(DynamicObject metaClass) {
            return new StatType(this.logicalClass, metaClass);
        }
    }
}

