/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;

public class CoreString {
    private final RubyContext context;
    private final String literal;
    @CompilerDirectives.CompilationFinal
    private volatile Rope rope;
    @CompilerDirectives.CompilationFinal
    private volatile DynamicObject symbol;

    public CoreString(RubyContext context, String literal) {
        assert (CoreString.is7Bit(literal));
        this.context = context;
        this.literal = literal;
    }

    public Rope getRope() {
        if (this.rope == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.rope = this.context.getRopeTable().getRope(this.literal.getBytes(StandardCharsets.US_ASCII), (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_7BIT);
        }
        return this.rope;
    }

    public DynamicObject getSymbol() {
        if (this.symbol == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.symbol = this.context.getSymbolTable().getSymbol(this.getRope());
        }
        return this.symbol;
    }

    public DynamicObject createInstance() {
        return StringOperations.createString(this.context, this.getRope());
    }

    private static boolean is7Bit(String literal) {
        for (int n = 0; n < literal.length(); ++n) {
            if (literal.charAt(n) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.literal;
    }
}

