/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.List;
import org.jruby.truffle.interop.ForeignInvokeNodeSubNodeGen;
import org.jruby.truffle.interop.RubyMessageResolution;

abstract class ForeignInvokeNodeSub
extends RubyMessageResolution.ForeignInvokeNode {
    ForeignInvokeNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, DynamicObject receiver, String name, Object[] arguments) {
        return this.access(frame, receiver, name, arguments);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new INVOKERootNode(language);
    }

    private static final class INVOKERootNode
    extends RootNode {
        @Node.Child
        private ForeignInvokeNodeSub node = ForeignInvokeNodeSubNodeGen.create();

        protected INVOKERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            try {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                List<Object> arguments = ForeignAccess.getArguments(frame);
                Object identifier = arguments.get(0);
                Object[] args = new Object[arguments.size() - 1];
                for (int i = 0; i < arguments.size() - 1; ++i) {
                    args[i] = arguments.get(i + 1);
                }
                return this.node.executeWithTarget(frame, receiver, identifier, args);
            }
            catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
            }
        }
    }
}

