/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.BreakException;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.FrameOnStackMarker;
import org.jruby.truffle.language.control.RaiseException;

public class BreakNode
extends RubyNode {
    private final BreakID breakID;
    private final boolean ignoreMarker;
    @Node.Child
    private RubyNode child;
    private final BranchProfile breakFromProcClosureProfile = BranchProfile.create();

    public BreakNode(RubyContext context, SourceSection sourceSection, BreakID breakID, boolean ignoreMarker, RubyNode child) {
        super(context, sourceSection);
        this.breakID = breakID;
        this.ignoreMarker = ignoreMarker;
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        FrameOnStackMarker marker;
        if (!this.ignoreMarker && (marker = RubyArguments.getFrameOnStackMarker(frame)) != null && !marker.isOnStack()) {
            this.breakFromProcClosureProfile.enter();
            throw new RaiseException(this.coreExceptions().breakFromProcClosure(this));
        }
        throw new BreakException(this.breakID, this.child.execute(frame));
    }
}

