/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.exceptions.RescueNode;

public class RescueClassesNode
extends RescueNode {
    @Node.Children
    final RubyNode[] handlingClassNodes;

    public RescueClassesNode(RubyContext context, SourceSection sourceSection, RubyNode[] handlingClassNodes, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassNodes = handlingClassNodes;
    }

    @Override
    @ExplodeLoop
    public boolean canHandle(VirtualFrame frame, DynamicObject exception) {
        for (RubyNode handlingClassNode : this.handlingClassNodes) {
            DynamicObject handlingClass = (DynamicObject)handlingClassNode.execute(frame);
            if (!this.getIsANode().executeIsA(exception, handlingClass)) continue;
            return true;
        }
        return false;
    }
}

