/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNodeGen;

public class SetExceptionVariableNode
extends Node {
    private final RubyContext context;
    @Node.Child
    private ThreadLocalObjectNode threadLocalNode;
    @Node.Child
    private ReadObjectFieldNode readDollarBang;
    @Node.Child
    private WriteObjectFieldNode writeDollarBang;

    public SetExceptionVariableNode(RubyContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setLastExceptionAndRun(VirtualFrame frame, RaiseException exception, RubyNode node) {
        DynamicObject threadLocals = this.getThreadLocalsObject(frame);
        Object lastException = this.readDollarBang(threadLocals);
        this.writeDollarBang(threadLocals, exception.getException());
        try {
            Object object = node.execute(frame);
            return object;
        }
        finally {
            this.writeDollarBang(threadLocals, lastException);
        }
    }

    private DynamicObject getThreadLocalsObject(VirtualFrame frame) {
        if (this.threadLocalNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.threadLocalNode = this.insert(ThreadLocalObjectNodeGen.create(this.context, this.getEncapsulatingSourceSection()));
        }
        return this.threadLocalNode.executeDynamicObject(frame);
    }

    private void writeDollarBang(DynamicObject threadLocals, Object value) {
        if (this.writeDollarBang == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.writeDollarBang = this.insert(WriteObjectFieldNodeGen.create("$!"));
        }
        this.writeDollarBang.execute(threadLocals, value);
    }

    private Object readDollarBang(DynamicObject threadLocals) {
        if (this.readDollarBang == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readDollarBang = this.insert(ReadObjectFieldNodeGen.create("$!", this.context.getCoreLibrary().getNilObject()));
        }
        return this.readDollarBang.execute(threadLocals);
    }
}

