/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;

public class FlipFlopNode
extends RubyNode {
    private final boolean exclusive;
    @Node.Child
    private BooleanCastNode begin;
    @Node.Child
    private BooleanCastNode end;
    @Node.Child
    private FlipFlopStateNode stateNode;

    public FlipFlopNode(RubyContext context, SourceSection sourceSection, RubyNode begin, RubyNode end, FlipFlopStateNode stateNode, boolean exclusive) {
        super(context, sourceSection);
        this.exclusive = exclusive;
        this.begin = BooleanCastNodeGen.create(begin);
        this.end = BooleanCastNodeGen.create(end);
        this.stateNode = stateNode;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (this.exclusive) {
            if (this.stateNode.getState(frame)) {
                if (this.end.executeBoolean(frame)) {
                    this.stateNode.setState(frame, false);
                }
                return true;
            }
            boolean newState = this.begin.executeBoolean(frame);
            this.stateNode.setState(frame, newState);
            return newState;
        }
        if (this.stateNode.getState(frame)) {
            if (this.end.executeBoolean(frame)) {
                this.stateNode.setState(frame, false);
            }
            return true;
        }
        if (this.begin.executeBoolean(frame)) {
            this.stateNode.setState(frame, !this.end.executeBoolean(frame));
            return true;
        }
        return false;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

