/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.java;

import jnr.ffi.provider.MemoryManager;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.queue.ArrayBlockingQueueLocksConditions;
import org.jruby.truffle.core.queue.LinkedBlockingQueueLocksConditions;
import org.jruby.truffle.platform.DefaultRubiniusConfiguration;
import org.jruby.truffle.platform.NativePlatform;
import org.jruby.truffle.platform.ProcessName;
import org.jruby.truffle.platform.RubiniusConfiguration;
import org.jruby.truffle.platform.java.JavaClockGetTime;
import org.jruby.truffle.platform.java.JavaMemoryManager;
import org.jruby.truffle.platform.java.JavaProcessName;
import org.jruby.truffle.platform.java.JavaSockets;
import org.jruby.truffle.platform.java.JavaTrufflePosix;
import org.jruby.truffle.platform.linux.LinuxRubiniusConfiguration;
import org.jruby.truffle.platform.openjdk.OpenJDKArrayBlockingQueueLocksConditions;
import org.jruby.truffle.platform.openjdk.OpenJDKLinkedBlockingQueueLocksConditions;
import org.jruby.truffle.platform.posix.ClockGetTime;
import org.jruby.truffle.platform.posix.Sockets;
import org.jruby.truffle.platform.posix.TrufflePosix;
import org.jruby.truffle.platform.posix.TrufflePosixHandler;
import org.jruby.truffle.platform.signal.SignalManager;
import org.jruby.truffle.platform.sunmisc.SunMiscSignalManager;

public class JavaPlatform
implements NativePlatform {
    private final TrufflePosix posix;
    private final MemoryManager memoryManager;
    private final SignalManager signalManager;
    private final ProcessName processName;
    private final Sockets sockets;
    private final ClockGetTime clockGetTime;
    private final RubiniusConfiguration rubiniusConfiguration;

    public JavaPlatform(RubyContext context) {
        this.posix = new JavaTrufflePosix(POSIXFactory.getJavaPOSIX((POSIXHandler)new TrufflePosixHandler(context)));
        this.memoryManager = new JavaMemoryManager();
        this.signalManager = new SunMiscSignalManager();
        this.processName = new JavaProcessName();
        this.sockets = new JavaSockets();
        this.clockGetTime = new JavaClockGetTime();
        this.rubiniusConfiguration = new RubiniusConfiguration();
        DefaultRubiniusConfiguration.load(this.rubiniusConfiguration, context);
        LinuxRubiniusConfiguration.load(this.rubiniusConfiguration, context);
    }

    @Override
    public TrufflePosix getPosix() {
        return this.posix;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public ProcessName getProcessName() {
        return this.processName;
    }

    @Override
    public Sockets getSockets() {
        return this.sockets;
    }

    @Override
    public ClockGetTime getClockGetTime() {
        return this.clockGetTime;
    }

    @Override
    public RubiniusConfiguration getRubiniusConfiguration() {
        return this.rubiniusConfiguration;
    }

    @Override
    public <T> ArrayBlockingQueueLocksConditions<T> createArrayBlockingQueueLocksConditions(int capacity) {
        return new OpenJDKArrayBlockingQueueLocksConditions(capacity);
    }

    @Override
    public <T> LinkedBlockingQueueLocksConditions<T> createLinkedBlockingQueueLocksConditions() {
        return new OpenJDKLinkedBlockingQueueLocksConditions();
    }
}

