/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.DummyDynamicScope;
import org.jruby.runtime.scope.FourVarDynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.runtime.scope.NoVarsDynamicScope;
import org.jruby.runtime.scope.OneVarDynamicScope;
import org.jruby.runtime.scope.ThreeVarDynamicScope;
import org.jruby.runtime.scope.TwoVarDynamicScope;

public abstract class DynamicScope {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    private EvalType evalType;
    private boolean lambda;

    protected DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this.staticScope = staticScope;
        this.parent = parent;
        this.evalType = EvalType.NONE;
    }

    protected DynamicScope(StaticScope staticScope) {
        this(staticScope, null);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent) {
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                return new NoVarsDynamicScope(staticScope, parent);
            }
            case 1: {
                return new OneVarDynamicScope(staticScope, parent);
            }
            case 2: {
                return new TwoVarDynamicScope(staticScope, parent);
            }
            case 3: {
                return new ThreeVarDynamicScope(staticScope, parent);
            }
            case 4: {
                return new FourVarDynamicScope(staticScope, parent);
            }
        }
        return new ManyVarsDynamicScope(staticScope, parent);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent, EvalType evalType) {
        DynamicScope newScope = DynamicScope.newDynamicScope(staticScope, parent);
        newScope.setEvalType(evalType);
        return newScope;
    }

    public static DynamicScope newDummyScope(StaticScope staticScope, DynamicScope parent) {
        return new DummyDynamicScope(staticScope, parent);
    }

    public final DynamicScope getParentScope() {
        return this.parent;
    }

    @Deprecated
    public DynamicScope getNextCapturedScope() {
        return this.getParentScope();
    }

    public DynamicScope getNthParentScope(int n) {
        DynamicScope scope = this;
        for (int i2 = 0; i2 < n && scope != null; scope = scope.getParentScope(), ++i2) {
        }
        return scope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public DynamicScope getFlipScope() {
        if (this.staticScope.getLocalScope() == this.staticScope) {
            return this;
        }
        return this.parent.getFlipScope();
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public abstract void growIfNeeded();

    public abstract DynamicScope cloneScope();

    public abstract IRubyObject[] getValues();

    public abstract IRubyObject getValue(int var1, int var2);

    public abstract IRubyObject getValueOrNil(int var1, int var2, IRubyObject var3);

    public abstract IRubyObject getValueDepthZeroOrNil(int var1, IRubyObject var2);

    public abstract IRubyObject getValueZeroDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueOneDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueTwoDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueThreeDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject setValue(int var1, IRubyObject var2, int var3);

    public IRubyObject setValue(IRubyObject value2, int offset2, int depth) {
        return this.setValue(offset2, value2, depth);
    }

    public void setValueVoid(IRubyObject value2, int offset2, int depth) {
        this.setValue(offset2, value2, depth);
    }

    public abstract IRubyObject setValueDepthZero(IRubyObject var1, int var2);

    public void setValueDepthZeroVoid(IRubyObject value2, int offset2) {
        this.setValueDepthZero(value2, offset2);
    }

    public abstract IRubyObject setValueZeroDepthZero(IRubyObject var1);

    public void setValueZeroDepthZeroVoid(IRubyObject value2) {
        this.setValueZeroDepthZero(value2);
    }

    public abstract IRubyObject setValueOneDepthZero(IRubyObject var1);

    public void setValueOneDepthZeroVoid(IRubyObject value2) {
        this.setValueOneDepthZero(value2);
    }

    public abstract IRubyObject setValueTwoDepthZero(IRubyObject var1);

    public void setValueTwoDepthZeroVoid(IRubyObject value2) {
        this.setValueTwoDepthZero(value2);
    }

    public abstract IRubyObject setValueThreeDepthZero(IRubyObject var1);

    public void setValueThreeDepthZeroVoid(IRubyObject value2) {
        this.setValueThreeDepthZero(value2);
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope.isBlockScope() ? "block" : "local") + " [");
        int size2 = this.staticScope.getNumberOfVariables();
        IRubyObject[] variableValues = this.getValues();
        if (size2 != 0) {
            String[] names2 = this.staticScope.getVariables();
            for (int i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(names2[i2]).append("=");
                if (variableValues[i2] == null) {
                    buf.append("null");
                } else {
                    buf.append(variableValues[i2]);
                }
                buf.append(",");
            }
            buf.append(names2[size2 - 1]).append("=");
            assert (variableValues.length == names2.length) : "V: " + variableValues.length + " != N: " + names2.length + " for " + buf;
            if (variableValues[size2 - 1] == null) {
                buf.append("null");
            } else {
                buf.append(variableValues[size2 - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }

    public boolean inInstanceEval() {
        return this.evalType == EvalType.INSTANCE_EVAL;
    }

    public boolean inModuleEval() {
        return this.evalType == EvalType.MODULE_EVAL;
    }

    public boolean inBindingEval() {
        return this.evalType == EvalType.BINDING_EVAL;
    }

    public void setEvalType(EvalType evalType) {
        this.evalType = evalType == null ? EvalType.NONE : evalType;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public void clearEvalType() {
        this.evalType = EvalType.NONE;
    }

    public void setLambda(boolean lambda2) {
        this.lambda = lambda2;
    }

    public boolean isLambda() {
        return this.lambda;
    }
}

