/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL location;
    private transient CodeSigner[] signers = null;
    private transient Certificate[] certs = null;
    private transient SocketPermission sp;
    private transient CertificateFactory factory = null;

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.location = uRL;
        if (certificateArray != null) {
            this.certs = (Certificate[])certificateArray.clone();
        }
    }

    public CodeSource(URL uRL, CodeSigner[] codeSignerArray) {
        this.location = uRL;
        if (codeSignerArray != null) {
            this.signers = (CodeSigner[])codeSignerArray.clone();
        }
    }

    public int hashCode() {
        if (this.location != null) {
            return this.location.hashCode();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CodeSource)) {
            return false;
        }
        CodeSource codeSource = (CodeSource)object;
        if (this.location == null ? codeSource.location != null : !this.location.equals(codeSource.location)) {
            return false;
        }
        return this.matchCerts(codeSource, true);
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        if (this.certs != null) {
            return (Certificate[])this.certs.clone();
        }
        if (this.signers != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < this.signers.length; ++i) {
                arrayList.addAll(this.signers[i].getSignerCertPath().getCertificates());
            }
            this.certs = arrayList.toArray(new Certificate[arrayList.size()]);
            return (Certificate[])this.certs.clone();
        }
        return null;
    }

    public final CodeSigner[] getCodeSigners() {
        if (this.signers != null) {
            return (CodeSigner[])this.signers.clone();
        }
        if (this.certs != null) {
            this.signers = this.convertCertArrayToSignerArray(this.certs);
            return (CodeSigner[])this.signers.clone();
        }
        return null;
    }

    public boolean implies(CodeSource codeSource) {
        if (codeSource == null) {
            return false;
        }
        return this.matchCerts(codeSource, false) && this.matchLocation(codeSource);
    }

    private boolean matchCerts(CodeSource codeSource, boolean bl) {
        if (this.certs == null && this.signers == null) {
            if (bl) {
                return codeSource.certs == null && codeSource.signers == null;
            }
            return true;
        }
        if (this.signers != null && codeSource.signers != null) {
            if (bl && this.signers.length != codeSource.signers.length) {
                return false;
            }
            for (int i = 0; i < this.signers.length; ++i) {
                boolean bl2 = false;
                for (int j = 0; j < codeSource.signers.length; ++j) {
                    if (!this.signers[i].equals(codeSource.signers[j])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            return true;
        }
        if (this.certs != null && codeSource.certs != null) {
            if (bl && this.certs.length != codeSource.certs.length) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                boolean bl3 = false;
                for (int j = 0; j < codeSource.certs.length; ++j) {
                    if (!this.certs[i].equals(codeSource.certs[j])) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchLocation(CodeSource codeSource) {
        int n;
        if (this.location == null) {
            return true;
        }
        if (codeSource == null || codeSource.location == null) {
            return false;
        }
        if (this.location.equals(codeSource.location)) {
            return true;
        }
        if (!this.location.getProtocol().equalsIgnoreCase(codeSource.location.getProtocol())) {
            return false;
        }
        int n2 = this.location.getPort();
        if (n2 != -1) {
            int n3;
            n = codeSource.location.getPort();
            int n4 = n3 = n != -1 ? n : codeSource.location.getDefaultPort();
            if (n2 != n3) {
                return false;
            }
        }
        if (this.location.getFile().endsWith("/-")) {
            String string = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            if (!codeSource.location.getFile().startsWith(string)) {
                return false;
            }
        } else if (this.location.getFile().endsWith("/*")) {
            n = codeSource.location.getFile().lastIndexOf(47);
            if (n == -1) {
                return false;
            }
            String string = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            String string2 = codeSource.location.getFile().substring(0, n + 1);
            if (!string2.equals(string)) {
                return false;
            }
        } else if (!codeSource.location.getFile().equals(this.location.getFile()) && !codeSource.location.getFile().equals(this.location.getFile() + "/")) {
            return false;
        }
        if (this.location.getRef() != null && !this.location.getRef().equals(codeSource.location.getRef())) {
            return false;
        }
        String string = this.location.getHost();
        String string3 = codeSource.location.getHost();
        if (!(string == null || ("".equals(string) || "localhost".equals(string)) && ("".equals(string3) || "localhost".equals(string3)) || string.equals(string3))) {
            if (string3 == null) {
                return false;
            }
            if (this.sp == null) {
                this.sp = new SocketPermission(string, "resolve");
            }
            if (codeSource.sp == null) {
                codeSource.sp = new SocketPermission(string3, "resolve");
            }
            if (!this.sp.implies(codeSource.sp)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.location);
        if (this.certs != null && this.certs.length > 0) {
            for (int i = 0; i < this.certs.length; ++i) {
                stringBuilder.append(" " + this.certs[i]);
            }
        } else if (this.signers != null && this.signers.length > 0) {
            for (int i = 0; i < this.signers.length; ++i) {
                stringBuilder.append(" " + this.signers[i]);
            }
        } else {
            stringBuilder.append(" <no signer certificates>");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                Certificate certificate = this.certs[i];
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
            }
        }
        if (this.signers != null && this.signers.length > 0) {
            objectOutputStream.writeObject(this.signers);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable<String, CertificateFactory> hashtable = null;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            hashtable = new Hashtable<String, CertificateFactory>(3);
            this.certs = new Certificate[n];
        }
        for (int i = 0; i < n; ++i) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)hashtable.get(string);
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw new ClassNotFoundException("Certificate factory for " + string + " not found");
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("Certificate too big");
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.certs[i] = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            byteArrayInputStream.close();
        }
        try {
            this.signers = (CodeSigner[])((CodeSigner[])objectInputStream.readObject()).clone();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        try {
            if (this.factory == null) {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            int n = 0;
            ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
            while (n < certificateArray.length) {
                int n2;
                ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
                arrayList2.add(certificateArray[n++]);
                for (n2 = n; n2 < certificateArray.length && certificateArray[n2] instanceof X509Certificate && ((X509Certificate)certificateArray[n2]).getBasicConstraints() != -1; ++n2) {
                    arrayList2.add(certificateArray[n2]);
                }
                n = n2;
                CertPath certPath = this.factory.generateCertPath(arrayList2);
                arrayList.add(new CodeSigner(certPath, null));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return arrayList.toArray(new CodeSigner[arrayList.size()]);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }
}

