/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private SecureRandom random;
    private final byte[] fixedIv;
    private final Key key;
    private final int mode;
    private final int tagSize;
    private final int recordIvSize;
    private final CipherSuite.CipherType cipherType;
    private static Hashtable<Integer, IvParameterSpec> masks;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
        this.cipherType = CipherSuite.CipherType.STREAM_CIPHER;
        this.fixedIv = new byte[0];
        this.key = null;
        this.mode = 1;
        this.random = null;
        this.tagSize = 0;
        this.recordIvSize = 0;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom, boolean bl) throws NoSuchAlgorithmException {
        try {
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int n = this.mode = bl ? 1 : 2;
            if (secureRandom == null) {
                secureRandom = JsseJce.getSecureRandom();
            }
            this.random = secureRandom;
            this.cipherType = bulkCipher.cipherType;
            if (ivParameterSpec == null && bulkCipher.ivSize != 0 && this.mode == 2 && protocolVersion.v >= ProtocolVersion.TLS11.v) {
                ivParameterSpec = CipherBox.getFixedMask(bulkCipher.ivSize);
            }
            if (this.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
                this.tagSize = bulkCipher.tagSize;
                this.key = secretKey;
                this.fixedIv = ivParameterSpec.getIV();
                if (this.fixedIv == null || this.fixedIv.length != bulkCipher.fixedIvSize) {
                    throw new RuntimeException("Improper fixed IV for AEAD");
                }
                this.recordIvSize = bulkCipher.ivSize - bulkCipher.fixedIvSize;
            } else {
                this.tagSize = 0;
                this.fixedIv = new byte[0];
                this.recordIvSize = 0;
                this.key = null;
                this.cipher.init(this.mode, (Key)secretKey, ivParameterSpec, secureRandom);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exception);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, exceptionInInitializerError);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey secretKey, IvParameterSpec ivParameterSpec, SecureRandom secureRandom, boolean bl) throws NoSuchAlgorithmException {
        if (!bulkCipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + bulkCipher);
        }
        if (bulkCipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(protocolVersion, bulkCipher, secretKey, ivParameterSpec, secureRandom, bl);
    }

    private static IvParameterSpec getFixedMask(int n) {
        IvParameterSpec ivParameterSpec;
        if (masks == null) {
            masks = new Hashtable(5);
        }
        if ((ivParameterSpec = masks.get(n)) == null) {
            ivParameterSpec = new IvParameterSpec(new byte[n]);
            masks.put(n, ivParameterSpec);
        }
        return ivParameterSpec;
    }

    int encrypt(byte[] byArray, int n, int n2) {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n3 = this.cipher.getBlockSize();
            if (this.cipherType == CipherSuite.CipherType.BLOCK_CIPHER) {
                n2 = CipherBox.addPadding(byArray, n, n2, n3);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + n2);
                    hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
                try {
                    return this.cipher.doFinal(byArray, n, n2, byArray, n);
                }
                catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                    throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), generalSecurityException);
                }
            }
            int n4 = this.cipher.update(byArray, n, n2, byArray, n);
            if (n4 != n2) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return n4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int encrypt(ByteBuffer byteBuffer, int n) {
        int n2;
        ByteBuffer byteBuffer2;
        int n3 = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n3;
        }
        int n4 = byteBuffer.position();
        int n5 = this.cipher.getBlockSize();
        if (this.cipherType == CipherSuite.CipherType.BLOCK_CIPHER) {
            n3 = CipherBox.addPadding(byteBuffer, n5);
            byteBuffer.position(n4);
        }
        if (debug != null && Debug.isOn("plaintext")) {
            try {
                byteBuffer2 = new HexDumpEncoder();
                System.out.println("Padded plaintext before ENCRYPTION:  len = " + n3);
                byteBuffer2.encodeBuffer(byteBuffer.duplicate(), System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byteBuffer2 = byteBuffer.duplicate();
        if (this.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
            try {
                int n6;
                int n7 = this.cipher.getOutputSize(byteBuffer2.remaining());
                if (n7 > byteBuffer.remaining()) {
                    if (n < n4 + n7) {
                        throw new ShortBufferException("need more space in output buffer");
                    }
                    byteBuffer.limit(n4 + n7);
                }
                if ((n6 = this.cipher.doFinal(byteBuffer2, byteBuffer)) != n7) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
                return n6;
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException generalSecurityException) {
                throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), generalSecurityException);
            }
        }
        try {
            n2 = this.cipher.update(byteBuffer2, byteBuffer);
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
        }
        if (byteBuffer.position() != byteBuffer2.position()) {
            throw new RuntimeException("bytebuffer padding error");
        }
        if (n2 != n3) {
            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
        }
        return n2;
    }

    int decrypt(byte[] byArray, int n, int n2, int n3) throws BadPaddingException {
        if (this.cipher == null) {
            return n2;
        }
        try {
            int n4;
            if (this.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
                try {
                    n4 = this.cipher.doFinal(byArray, n, n2, byArray, n);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), illegalBlockSizeException);
                }
            } else {
                n4 = this.cipher.update(byArray, n, n2, byArray, n);
                if (n4 != n2) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n4);
                    hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n4), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.cipherType == CipherSuite.CipherType.BLOCK_CIPHER) {
                int n5 = this.cipher.getBlockSize();
                n4 = CipherBox.removePadding(byArray, n, n4, n3, n5, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v && n4 < n5) {
                    throw new BadPaddingException("invalid explicit IV");
                }
            }
            return n4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    int decrypt(ByteBuffer byteBuffer, int n) throws BadPaddingException {
        int n2 = byteBuffer.remaining();
        if (this.cipher == null) {
            byteBuffer.position(byteBuffer.limit());
            return n2;
        }
        try {
            int n3;
            int n4 = byteBuffer.position();
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            if (this.cipherType == CipherSuite.CipherType.AEAD_CIPHER) {
                try {
                    n3 = this.cipher.doFinal(byteBuffer2, byteBuffer);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new RuntimeException("Cipher error in AEAD mode \"" + illegalBlockSizeException.getMessage() + " \"in JCE provider " + this.cipher.getProvider().getName());
                }
            } else {
                n3 = this.cipher.update(byteBuffer2, byteBuffer);
                if (n3 != n2) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
            }
            byteBuffer.limit(n4 + n3);
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + n3);
                    hexDumpEncoder.encodeBuffer((ByteBuffer)byteBuffer.duplicate().position(n4), (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.cipherType == CipherSuite.CipherType.BLOCK_CIPHER) {
                int n5 = this.cipher.getBlockSize();
                byteBuffer.position(n4);
                n3 = CipherBox.removePadding(byteBuffer, n, n5, this.protocolVersion);
                if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    if (n3 < n5) {
                        throw new BadPaddingException("invalid explicit IV");
                    }
                    byteBuffer.position(byteBuffer.limit());
                }
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ArrayIndexOutOfBoundsException(shortBufferException.toString());
        }
    }

    private static int addPadding(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + 1;
        if (n4 % n3 != 0) {
            n4 += n3 - 1;
            n4 -= n4 % n3;
        }
        int n5 = n4 - n2;
        if (byArray.length < n4 + n) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        n += n2;
        for (int i = 0; i < n5; ++i) {
            byArray[n++] = (byte)(n5 - 1);
        }
        return n4;
    }

    private static int addPadding(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = n2 + 1;
        if (n4 % n != 0) {
            n4 += n - 1;
            n4 -= n4 % n;
        }
        int n5 = n4 - n2;
        byteBuffer.limit(n4 + n3);
        n3 += n2;
        for (int i = 0; i < n5; ++i) {
            byteBuffer.put(n3++, (byte)(n5 - 1));
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n3);
        return n4;
    }

    private static int[] checkPadding(byte[] byArray, int n, int n2, byte by) {
        if (n2 <= 0) {
            throw new RuntimeException("padding len must be positive");
        }
        int[] nArray = new int[]{0, 0};
        int n3 = 0;
        while (n3 <= 256) {
            for (int i = 0; i < n2 && n3 <= 256; ++i, ++n3) {
                if (byArray[n + i] != by) {
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                nArray[1] = nArray[1] + 1;
            }
        }
        return nArray;
    }

    private static int[] checkPadding(ByteBuffer byteBuffer, byte by) {
        if (!byteBuffer.hasRemaining()) {
            throw new RuntimeException("hasRemaining() must be positive");
        }
        int[] nArray = new int[]{0, 0};
        byteBuffer.mark();
        int n = 0;
        while (n <= 256) {
            while (byteBuffer.hasRemaining() && n <= 256) {
                if (byteBuffer.get() != by) {
                    nArray[0] = nArray[0] + 1;
                } else {
                    nArray[1] = nArray[1] + 1;
                }
                ++n;
            }
            byteBuffer.reset();
        }
        return nArray;
    }

    private static int removePadding(byte[] byArray, int n, int n2, int n3, int n4, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n5 = n + n2 - 1;
        int n6 = byArray[n5] & 0xFF;
        int n7 = n2 - (n6 + 1);
        if (n7 - n3 < 0) {
            CipherBox.checkPadding(byArray, n, n2, (byte)(n6 & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + n6);
        }
        int[] nArray = CipherBox.checkPadding(byArray, n + n7, n6 + 1, (byte)(n6 & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (nArray[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (n6 > n4) {
            throw new BadPaddingException("Invalid SSLv3 padding");
        }
        return n7;
    }

    private static int removePadding(ByteBuffer byteBuffer, int n, int n2, ProtocolVersion protocolVersion) throws BadPaddingException {
        int n3;
        int n4;
        int n5;
        int n6 = byteBuffer.remaining();
        int n7 = n6 - ((n5 = byteBuffer.get(n4 = (n3 = byteBuffer.position()) + n6 - 1) & 0xFF) + 1);
        if (n7 - n < 0) {
            CipherBox.checkPadding(byteBuffer.duplicate(), (byte)(n5 & 0xFF));
            throw new BadPaddingException("Invalid Padding length: " + n5);
        }
        int[] nArray = CipherBox.checkPadding((ByteBuffer)byteBuffer.duplicate().position(n3 + n7), (byte)(n5 & 0xFF));
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            if (nArray[0] != 0) {
                throw new BadPaddingException("Invalid TLS padding data");
            }
        } else if (n5 > n2) {
            throw new BadPaddingException("Invalid SSLv3 padding");
        }
        byteBuffer.position(n3 + n7);
        byteBuffer.limit(n3 + n7);
        return n7;
    }

    void dispose() {
        try {
            if (this.cipher != null) {
                this.cipher.doFinal();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isCBCMode() {
        return this.cipherType == CipherSuite.CipherType.BLOCK_CIPHER;
    }

    boolean isAEADMode() {
        return this.cipherType == CipherSuite.CipherType.AEAD_CIPHER;
    }

    boolean isNullCipher() {
        return this.cipher == null;
    }

    int getExplicitNonceSize() {
        switch (this.cipherType) {
            case BLOCK_CIPHER: {
                if (this.protocolVersion.v < ProtocolVersion.TLS11.v) break;
                return this.cipher.getBlockSize();
            }
            case AEAD_CIPHER: {
                return this.recordIvSize;
            }
        }
        return 0;
    }

    int applyExplicitNonce(Authenticator authenticator, byte by, ByteBuffer byteBuffer) throws BadPaddingException {
        switch (this.cipherType) {
            case BLOCK_CIPHER: {
                int n;
                int n2 = n = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
                if (n != 0 && !this.sanityCheck(n, byteBuffer.remaining())) {
                    throw new BadPaddingException("ciphertext sanity check failed");
                }
                if (this.protocolVersion.v < ProtocolVersion.TLS11.v) break;
                return this.cipher.getBlockSize();
            }
            case AEAD_CIPHER: {
                if (byteBuffer.remaining() < this.recordIvSize + this.tagSize) {
                    throw new BadPaddingException("invalid AEAD cipher fragment");
                }
                byte[] byArray = Arrays.copyOf(this.fixedIv, this.fixedIv.length + this.recordIvSize);
                byteBuffer.get(byArray, this.fixedIv.length, this.recordIvSize);
                byteBuffer.position(byteBuffer.position() - this.recordIvSize);
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray);
                try {
                    this.cipher.init(this.mode, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                byte[] byArray2 = authenticator.acquireAuthenticationBytes(by, byteBuffer.remaining() - this.recordIvSize - this.tagSize);
                this.cipher.updateAAD(byArray2);
                return this.recordIvSize;
            }
        }
        return 0;
    }

    int applyExplicitNonce(Authenticator authenticator, byte by, byte[] byArray, int n, int n2) throws BadPaddingException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        return this.applyExplicitNonce(authenticator, by, byteBuffer);
    }

    byte[] createExplicitNonce(Authenticator authenticator, byte by, int n) {
        byte[] byArray = new byte[]{};
        switch (this.cipherType) {
            case BLOCK_CIPHER: {
                if (this.protocolVersion.v < ProtocolVersion.TLS11.v) break;
                byArray = new byte[this.cipher.getBlockSize()];
                this.random.nextBytes(byArray);
                break;
            }
            case AEAD_CIPHER: {
                byArray = authenticator.sequenceNumber();
                byte[] byArray2 = Arrays.copyOf(this.fixedIv, this.fixedIv.length + byArray.length);
                System.arraycopy(byArray, 0, byArray2, this.fixedIv.length, byArray.length);
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagSize * 8, byArray2);
                try {
                    this.cipher.init(this.mode, this.key, gCMParameterSpec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                    throw new RuntimeException("invalid key or spec in GCM mode", generalSecurityException);
                }
                byte[] byArray3 = authenticator.acquireAuthenticationBytes(by, n);
                this.cipher.updateAAD(byArray3);
            }
        }
        return byArray;
    }

    private boolean sanityCheck(int n, int n2) {
        if (!this.isCBCMode()) {
            return n2 >= n;
        }
        int n3 = this.cipher.getBlockSize();
        if (n2 % n3 == 0) {
            int n4 = n + 1;
            int n5 = n4 = n4 >= n3 ? n4 : n3;
            if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                n4 += n3;
            }
            return n2 >= n4;
        }
        return false;
    }
}

