/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilterEditorPanel {
    private JPanel mainPanel;
    private DefaultListModel model;
    private JList list;
    private JButton hideButton;
    private JButton showButton;

    public AbstractFilterEditorPanel() {
        this.setupUI();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.createOptionsPanel(), "North");
        this.mainPanel.add(this.createListPanel(), "Center");
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.hideButton = new JButton(new AbstractAction("Hide"){

            public void actionPerformed(ActionEvent e) {
                AbstractFilterEditorPanel.this.hideSelected();
            }
        });
        this.showButton = new JButton(new AbstractAction("Show"){

            public void actionPerformed(ActionEvent e) {
                AbstractFilterEditorPanel.this.showSelected();
            }
        });
        panel.add(this.showButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.hideButton);
        panel.add(Box.createHorizontalGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        return panel;
    }

    private Component createListPanel() {
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new FilterRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AbstractFilterEditorPanel.this.enableAppropriately();
                }
            }
        });
        return new JScrollPane(this.list);
    }

    protected abstract boolean isAllowed(String var1);

    public void enableAppropriately() {
        boolean isShowEnabled = false;
        boolean isHideEnabled = false;
        List<String> selectedObjects = this.getSelectedValues();
        if (selectedObjects.isEmpty()) {
            isShowEnabled = false;
            isHideEnabled = false;
        } else {
            StateHolder stateHolder = new StateHolder();
            this.determineShowHideEnabledState(stateHolder, selectedObjects);
            isShowEnabled = stateHolder.containsHiddenObjects;
            isHideEnabled = stateHolder.containsShownObjects;
        }
        this.showButton.setEnabled(isShowEnabled);
        this.hideButton.setEnabled(isHideEnabled);
    }

    protected void determineShowHideEnabledState(StateHolder stateHolder, List<String> selectedObjects) {
        Iterator<String> iterator = selectedObjects.iterator();
        while (!(!iterator.hasNext() || stateHolder.containsHiddenObjects && stateHolder.containsShownObjects)) {
            String object = iterator.next();
            if (this.isAllowed(object)) {
                stateHolder.containsShownObjects = true;
                continue;
            }
            stateHolder.containsHiddenObjects = true;
        }
    }

    protected List<String> getSelectedValues() {
        Object[] objects = this.list.getSelectedValues();
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> nodes = new ArrayList<String>();
        for (int index = 0; index < objects.length; ++index) {
            Object object = objects[index];
            nodes.add((String)object);
        }
        return nodes;
    }

    private void hideSelected() {
        List<String> selection = this.getSelectedValues();
        this.hideSelected(selection);
        this.enableAppropriately();
        this.list.repaint();
    }

    protected abstract void hideSelected(List<String> var1);

    private void showSelected() {
        List<String> selection = this.getSelectedValues();
        this.showSelected(selection);
        this.enableAppropriately();
        this.list.repaint();
    }

    protected abstract void showSelected(List<String> var1);

    public void populate(List<String> items) {
        this.model.clear();
        for (String item : items) {
            this.model.addElement(item);
        }
    }

    protected class StateHolder {
        boolean containsHiddenObjects;
        boolean containsShownObjects;

        protected StateHolder() {
        }
    }

    private class FilterRenderer
    extends DefaultListCellRenderer {
        private Color defaultForegroundColor = this.getForeground();

        private FilterRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
            boolean isAllowed = AbstractFilterEditorPanel.this.isAllowed((String)value);
            if (isAllowed) {
                this.setForeground(this.defaultForegroundColor);
            } else {
                this.setForeground(Color.red);
            }
            return component;
        }
    }
}

