/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.builder.StubClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;

class KotlinLightClassBuilderFactory
implements ClassBuilderFactory {
    private final Stack<StubElement> stubStack;

    public KotlinLightClassBuilderFactory(Stack<StubElement> stubStack) {
        this.stubStack = stubStack;
    }

    @Override
    @NotNull
    public ClassBuilderMode getClassBuilderMode() {
        ClassBuilderMode classBuilderMode = ClassBuilderMode.LIGHT_CLASSES;
        if (classBuilderMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/KotlinLightClassBuilderFactory", "getClassBuilderMode"));
        }
        return classBuilderMode;
    }

    @Override
    @NotNull
    public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/builder/KotlinLightClassBuilderFactory", "newClassBuilder"));
        }
        StubClassBuilder stubClassBuilder = new StubClassBuilder(this.stubStack);
        if (stubClassBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/KotlinLightClassBuilderFactory", "newClassBuilder"));
        }
        return stubClassBuilder;
    }

    @Override
    public String asText(ClassBuilder builder) {
        throw new UnsupportedOperationException("asText is not implemented");
    }

    @Override
    public byte[] asBytes(ClassBuilder builder) {
        throw new UnsupportedOperationException("asBytes is not implemented");
    }

    @Override
    public void close() {
    }
}

