/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.ModifierFlags;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class JavaStubIndexer {
    @Nullable
    public static IndexTree.Unit translate(int fileId, PsiJavaFileStub javaFileStub) {
        ArrayList<IndexTree.ClassDecl> classList = new ArrayList<IndexTree.ClassDecl>();
        HashSet<String> usedNames = new HashSet<String>();
        for (StubElement stubElement : javaFileStub.getChildrenStubs()) {
            IndexTree.ClassDecl classDecl;
            if (!(stubElement instanceof PsiClassStubImpl) || (classDecl = JavaStubIndexer.processClassDecl((PsiClassStubImpl)stubElement, usedNames)) == null) continue;
            classList.add(classDecl);
        }
        ArrayList<IndexTree.Import> importList = new ArrayList<IndexTree.Import>();
        for (StubElement el : javaFileStub.getChildrenStubs()) {
            if (!(el instanceof PsiImportListStub)) continue;
            JavaStubIndexer.processImport((PsiImportListStub)el, importList, usedNames);
        }
        IndexTree.ClassDecl[] classDeclArray = classList.isEmpty() ? IndexTree.ClassDecl.EMPTY_ARRAY : classList.toArray(new IndexTree.ClassDecl[classList.size()]);
        IndexTree.Import[] imports = importList.isEmpty() ? IndexTree.Import.EMPTY_ARRAY : importList.toArray(new IndexTree.Import[importList.size()]);
        byte type2 = javaFileStub.isCompiled() ? IndexTree.BYTECODE : IndexTree.JAVA;
        return new IndexTree.Unit(fileId, javaFileStub.getPackageName(), type2, imports, classDeclArray);
    }

    @Nullable
    private static IndexTree.Decl processMember(StubElement<?> el, Set<String> namesCache) {
        PsiClassStubImpl classStub;
        if (el instanceof PsiClassStubImpl && !(classStub = (PsiClassStubImpl)el).isAnonymousInQualifiedNew()) {
            return JavaStubIndexer.processClassDecl(classStub, namesCache);
        }
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        for (StubElement childElement : el.getChildrenStubs()) {
            IndexTree.Decl innerDef = JavaStubIndexer.processMember(childElement, namesCache);
            if (innerDef == null) continue;
            innerList.add(innerDef);
        }
        return innerList.isEmpty() ? null : new IndexTree.MemberDecl(innerList.toArray(new IndexTree.Decl[innerList.size()]));
    }

    @Nullable
    private static IndexTree.ClassDecl processClassDecl(PsiClassStubImpl<?> classStub, Set<String> namesCache) {
        ArrayList<String> superList = new ArrayList<String>();
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        int accessModifiers = 0;
        if (classStub.isAnonymous() && classStub.getBaseClassReferenceText() != null) {
            superList.add(JavaStubIndexer.id(classStub.getBaseClassReferenceText(), true, namesCache));
        }
        for (StubElement el : classStub.getChildrenStubs()) {
            IndexTree.Decl member;
            if (el instanceof PsiClassReferenceListStub) {
                PsiClassReferenceListStub refList = (PsiClassReferenceListStub)el;
                if (refList.getRole() == PsiReferenceList.Role.EXTENDS_LIST) {
                    String[] extendNames;
                    for (String extName : extendNames = refList.getReferencedNames()) {
                        superList.add(JavaStubIndexer.id(extName, true, namesCache));
                    }
                }
                if (refList.getRole() == PsiReferenceList.Role.IMPLEMENTS_LIST) {
                    String[] implementNames;
                    for (String impName : implementNames = refList.getReferencedNames()) {
                        superList.add(JavaStubIndexer.id(impName, true, namesCache));
                    }
                }
            }
            if (el instanceof PsiModifierListStub) {
                accessModifiers = ((PsiModifierListStub)el).getModifiersMask();
            }
            if ((member = JavaStubIndexer.processMember(el, namesCache)) == null) continue;
            innerList.add(member);
        }
        int flags = JavaStubIndexer.translateFlags(classStub, accessModifiers);
        String[] supers = superList.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(superList);
        IndexTree.Decl[] inners = innerList.isEmpty() ? IndexTree.Decl.EMPTY_ARRAY : innerList.toArray(new IndexTree.Decl[innerList.size()]);
        return new IndexTree.ClassDecl(classStub.id, flags, classStub.getName(), supers, inners);
    }

    private static int translateFlags(PsiClassStubImpl<?> classStub, int accessModifiers) {
        int flags = 0;
        if (classStub.isInterface()) {
            flags |= 0x10;
        }
        if (classStub.isEnum()) {
            flags |= 0x40;
        }
        if (classStub.isAnnotationType()) {
            flags |= 0x20;
        }
        if (ModifierFlags.hasModifierProperty("static", accessModifiers)) {
            flags |= 8;
        }
        return flags;
    }

    private static void processImport(PsiImportListStub el, List<IndexTree.Import> imports, Set<String> namesCache) {
        for (StubElement importElem : el.getChildrenStubs()) {
            PsiImportStatementStub imp = (PsiImportStatementStub)importElem;
            String importReferenceText = imp.getImportReferenceText();
            if (importReferenceText == null) continue;
            String fullName = PsiNameHelper.getQualifiedClassName(importReferenceText, true);
            if (!imp.isOnDemand() && !namesCache.contains(JavaStubIndexer.shortName(fullName))) continue;
            imports.add(new IndexTree.Import(fullName, imp.isStatic(), imp.isOnDemand(), null));
        }
    }

    private static String id(String s, boolean cacheFirstId, Set<String> namesCache) {
        String id = PsiNameHelper.getQualifiedClassName(s, true);
        if (cacheFirstId) {
            int index2 = id.indexOf(46);
            String firstId = index2 > 0 ? s.substring(0, index2) : id;
            namesCache.add(firstId);
        }
        return id;
    }

    private static String shortName(String s) {
        int dotIndex = s.lastIndexOf(46);
        return dotIndex > 0 ? s.substring(dotIndex + 1) : null;
    }
}

