/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.Function;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    public String getStubAstMismatchDiagnostics(@NotNull VirtualFile file2, @NotNull PsiFile psiFile, @NotNull ObjectStubTree stubTree, @Nullable Document prevCachedDocument) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getStubAstMismatchDiagnostics"));
        }
        String msg2 = "";
        msg2 = msg2 + "\n file=" + psiFile;
        msg2 = msg2 + ", file.class=" + psiFile.getClass();
        msg2 = msg2 + ", file.lang=" + psiFile.getLanguage();
        msg2 = msg2 + ", modStamp=" + psiFile.getModificationStamp();
        if (!(psiFile instanceof PsiCompiledElement)) {
            String text2 = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text2);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg2 = consistent ? msg2 + "\n tree consistent" : msg2 + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        msg2 = msg2 + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg2 = msg2 + "\n document before=" + prevCachedDocument;
        ObjectStubTree latestIndexedStub = this.readFromVFile(psiFile.getProject(), file2);
        msg2 = msg2 + "\nlatestIndexedStub=" + latestIndexedStub;
        if (latestIndexedStub != null) {
            msg2 = msg2 + "\n   same size=" + (stubTree.getPlainList().size() == latestIndexedStub.getPlainList().size());
            msg2 = msg2 + "\n   debugInfo=" + latestIndexedStub.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg2 = msg2 + "\n viewProvider=" + viewProvider;
        msg2 = msg2 + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg2 = msg2 + "; file stamp: " + file2.getModificationStamp();
        msg2 = msg2 + "; file modCount: " + file2.getModificationCount();
        msg2 = msg2 + "; file length: " + file2.getLength();
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document != null) {
            msg2 = msg2 + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg2 = msg2 + "; doc stamp: " + document.getModificationStamp();
            msg2 = msg2 + "; doc size: " + document.getTextLength();
            msg2 = msg2 + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        return msg2;
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getFileViewProviderMismatchDiagnostics"));
        }
        Function<Language, String> languageID = new Function<Language, String>(){

            @Override
            public String fun(Language language) {
                return language.getID();
            }
        };
        final Function<PsiFile, String> fileClassName = new Function<PsiFile, String>(){

            @Override
            public String fun(PsiFile file2) {
                return file2.getClass().getSimpleName();
            }
        };
        Function<PsiFile, String> fileToFileType = new Function<PsiFile, String>(){

            @Override
            public String fun(PsiFile file2) {
                return file2.getFileType().getName();
            }
        };
        Function<Pair<IStubFileElementType, PsiFile>, String> stubRootToString = new Function<Pair<IStubFileElementType, PsiFile>, String>(){

            @Override
            public String fun(Pair<IStubFileElementType, PsiFile> pair) {
                return "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun(pair.second) + ")";
            }
        };
        List<Pair<IStubFileElementType, PsiFile>> roots2 = StubTreeBuilder.getStubbedRoots(provider);
        return "path = " + provider.getVirtualFile().getPath() + ", stubBindingRoot = " + (String)fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), languageID, ", ") + "], filesTypes = [" + StringUtil.join(provider.getAllFiles(), fileToFileType, ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots2, stubRootToString, ", ") + "]";
    }
}

