/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

public final class OperatorTable {
    private static final Map<KtToken, JsBinaryOperator> binaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.PLUS, JsBinaryOperator.ADD)).put(KtTokens.MINUS, JsBinaryOperator.SUB)).put(KtTokens.MUL, JsBinaryOperator.MUL)).put(KtTokens.DIV, JsBinaryOperator.DIV)).put(KtTokens.EQ, JsBinaryOperator.ASG)).put(KtTokens.GT, JsBinaryOperator.GT)).put(KtTokens.GTEQ, JsBinaryOperator.GTE)).put(KtTokens.LT, JsBinaryOperator.LT)).put(KtTokens.LTEQ, JsBinaryOperator.LTE)).put(KtTokens.ANDAND, JsBinaryOperator.AND)).put(KtTokens.OROR, JsBinaryOperator.OR)).put(KtTokens.PERC, JsBinaryOperator.MOD)).put(KtTokens.PLUSEQ, JsBinaryOperator.ASG_ADD)).put(KtTokens.MINUSEQ, JsBinaryOperator.ASG_SUB)).put(KtTokens.DIVEQ, JsBinaryOperator.ASG_DIV)).put(KtTokens.MULTEQ, JsBinaryOperator.ASG_MUL)).put(KtTokens.PERCEQ, JsBinaryOperator.ASG_MOD)).put(KtTokens.IN_KEYWORD, JsBinaryOperator.INOP)).put(KtTokens.EQEQEQ, JsBinaryOperator.REF_EQ)).put(KtTokens.EXCLEQEQEQ, JsBinaryOperator.REF_NEQ)).build();
    private static final ImmutableBiMap<KtToken, JsUnaryOperator> unaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.PLUSPLUS, JsUnaryOperator.INC)).put(KtTokens.MINUSMINUS, JsUnaryOperator.DEC)).put(KtTokens.EXCL, JsUnaryOperator.NOT)).put(KtTokens.MINUS, JsUnaryOperator.NEG)).put(KtTokens.PLUS, JsUnaryOperator.POS)).build();

    private OperatorTable() {
    }

    public static boolean hasCorrespondingOperator(@NotNull KtToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "hasCorrespondingOperator"));
        }
        return binaryOperatorsMap.containsKey(token) || unaryOperatorsMap.containsKey(token);
    }

    public static boolean hasCorrespondingBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "hasCorrespondingBinaryOperator"));
        }
        return binaryOperatorsMap.containsKey(token);
    }

    @NotNull
    public static JsBinaryOperator getBinaryOperator(@NotNull KtToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "getBinaryOperator"));
        }
        assert (KtTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsBinaryOperator jsBinaryOperator = binaryOperatorsMap.get(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "getBinaryOperator"));
        }
        return jsBinaryOperator;
    }

    @NotNull
    public static JsUnaryOperator getUnaryOperator(@NotNull KtToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "getUnaryOperator"));
        }
        assert (KtTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsUnaryOperator jsUnaryOperator = (JsUnaryOperator)unaryOperatorsMap.get(token);
        if (jsUnaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OperatorTable", "getUnaryOperator"));
        }
        return jsUnaryOperator;
    }
}

