/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.stats;

import org.gradle.internal.TimeProvider;
import org.gradle.util.Clock;

public class DaemonRunningStats {
    private final Clock runningClock;
    private final TimeProvider timeProvider;
    private int buildCount;
    private long currentBuildStart;
    private long allBuildsTime;

    public DaemonRunningStats(TimeProvider timeProvider, long startAt) {
        this.runningClock = new Clock(startAt);
        this.timeProvider = timeProvider;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public String getPrettyUpTime() {
        return this.runningClock.getTime();
    }

    public long getStartTime() {
        return this.runningClock.getStartTime();
    }

    public long getCurrentBuildStart() {
        return this.currentBuildStart;
    }

    public long getAllBuildsTime() {
        return this.allBuildsTime;
    }

    public void buildStarted() {
        ++this.buildCount;
        this.currentBuildStart = this.timeProvider.getCurrentTime();
    }

    public void buildFinished() {
        long buildTime = Math.max(this.timeProvider.getCurrentTime() - this.currentBuildStart, 1L);
        this.allBuildsTime += buildTime;
    }
}

