/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.ParallelTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPlanExecutorFactory
implements Factory<TaskPlanExecutor> {
    private final int parallelThreads;
    private final ExecutorFactory executorFactory;
    private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;

    public TaskPlanExecutorFactory(int parallelThreads, ExecutorFactory executorFactory, BuildOperationWorkerRegistry buildOperationWorkerRegistry) {
        this.parallelThreads = parallelThreads;
        this.executorFactory = executorFactory;
        this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
    }

    public TaskPlanExecutor create() {
        if (this.parallelThreads < 1) {
            throw new IllegalStateException(String.format("Cannot create executor for requested number of worker threads: %s.", this.parallelThreads));
        }
        if (this.parallelThreads > 1) {
            return new ParallelTaskPlanExecutor(this.parallelThreads, this.executorFactory, this.buildOperationWorkerRegistry);
        }
        return new DefaultTaskPlanExecutor(this.buildOperationWorkerRegistry);
    }
}

