/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.EnumCodeMapper;
import ch.interlis.iom_j.itf.ItfStartTransferEvent;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfLineCursor;
import ch.interlis.iom_j.itf.impl.ItfScanner;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ItfReader
implements IoxReader {
    private ItfScanner scanner = null;
    private ItfLineCursor itfLine = null;
    private int state = 0;
    private String modelName = null;
    private String topicName = null;
    private String className = null;
    private int basketCount = 0;
    private TransferDescription td = null;
    private HashMap tag2class = null;
    private InputStream inStream = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private boolean readEnumValAsItfCode = false;
    private boolean renumberTids = false;
    private HashMap tid2tid = null;
    private String undefinedCode = "@";
    private char blankCode = (char)95;
    private char continueCode = (char)92;
    private EnumCodeMapper enumMapper = new EnumCodeMapper();
    private long tid = 1L;

    public ItfReader(InputStream in) throws IoxException {
        try {
            this.scanner = new ItfScanner(in);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException(ex);
        }
        catch (IOException ex) {
            throw new IoxException(ex);
        }
        this.itfLine = new ItfLineCursor();
        this.state = 10;
    }

    public ItfReader(File inFile) throws IoxException {
        try {
            this.inStream = new FileInputStream(inFile);
        }
        catch (FileNotFoundException ex) {
            throw new IoxException(ex);
        }
        try {
            this.scanner = new ItfScanner(this.inStream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException(ex);
        }
        catch (IOException ex) {
            throw new IoxException(ex);
        }
        this.itfLine = new ItfLineCursor();
        this.state = 10;
    }

    @Override
    public void close() throws IoxException {
        if (this.scanner != null) {
            this.scanner.close();
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException ex) {
                throw new IoxException(ex);
            }
            this.inStream = null;
        }
        this.scanner = null;
        this.itfLine = null;
        this.state = 0;
        this.td = null;
        this.tag2class = null;
    }

    @Override
    public IoxEvent read() throws IoxException {
        IoxEvent event = null;
        IomObject iomObj = null;
        AttributeDef surfaceOrAreaAttr = null;
        ArrayList<AttributeDef> polylineattrs = null;
        int polyAttrIdx = 0;
        boolean polyAttrIs3D = false;
        IomObject polyAttrSequence = null;
        block14: while (true) {
            try {
                this.scanner.read(this.itfLine);
            }
            catch (IoxException ex) {
                throw new IoxException("failed to read logical line", (Throwable)ex);
            }
            int kind = this.itfLine.getKind();
            switch (this.state) {
                case 10: {
                    if (kind != 1) {
                        throw new IoxException(this.itfLine.getLineNumber(), "SCNT expected");
                    }
                    event = new ItfStartTransferEvent();
                    ((StartTransferEvent)event).setComment(this.itfLine.getContent());
                    this.state = 20;
                    continue block14;
                }
                case 20: {
                    String[] propv;
                    if (kind == 3) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        String modelId = propv[0];
                        if (modelId == null) {
                            throw new IoxException(this.itfLine.getLineNumber(), "missing model identification");
                        }
                        event.setModelId(modelId);
                    } else if (kind == 2) {
                        event.setModelDefinition(this.itfLine.getContent());
                    } else {
                        throw new IoxException(this.itfLine.getLineNumber(), "MTID or MOTR expected");
                    }
                    this.state = 40;
                    return event;
                }
                case 40: {
                    if (kind != 6) {
                        throw new IoxException(this.itfLine.getLineNumber(), "MODL expected");
                    }
                    String[] propv = this.splitItfLine(this.itfLine.getContent());
                    this.modelName = propv[0];
                    if (this.modelName == null) {
                        throw new IoxException(this.itfLine.getLineNumber(), "missing model name");
                    }
                    this.state = 41;
                    continue block14;
                }
                case 41: {
                    String[] propv;
                    if (kind == 8) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        this.topicName = propv[0];
                        if (this.topicName == null) {
                            throw new IoxException(this.itfLine.getLineNumber(), "missing topic name");
                        }
                        if (this.renumberTids) {
                            this.tid2tid = new HashMap();
                        }
                        this.state = 50;
                        event = new StartBasketEvent(String.valueOf(this.modelName) + "." + this.topicName, "itf" + Integer.toString(this.basketCount++));
                        return event;
                    }
                    if (kind == 7) {
                        this.state = 120;
                        continue block14;
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "TOPI or EMOD expected");
                }
                case 50: {
                    String[] propv;
                    if (kind == 10) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        this.className = propv[0];
                        if (this.className == null) {
                            throw new IoxException(this.itfLine.getLineNumber(), "missing table name");
                        }
                        EhiLogger.traceState(String.valueOf(this.className) + "...");
                        this.state = 60;
                        continue block14;
                    }
                    if (kind == 9) {
                        this.state = 41;
                        return new EndBasketEvent();
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "TABL or ETOP expected");
                }
                case 60: {
                    String[] propv;
                    if (kind == 11) {
                        this.className = null;
                        this.state = 50;
                        continue block14;
                    }
                    if (kind == 13) {
                        this.state = 62;
                        continue block14;
                    }
                    if (kind == 12) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        String tid = propv[0];
                        if (tid == null) {
                            throw new IoxException(this.itfLine.getLineNumber(), "missing tid");
                        }
                        if (this.tid2tid != null) {
                            String tid2 = this.newTid();
                            this.tid2tid.put(String.valueOf(this.className) + ":" + tid, tid2);
                            tid = tid2;
                        }
                        String iliQName = String.valueOf(this.modelName) + "." + this.topicName + "." + this.className;
                        iomObj = this.createIomObject(iliQName, tid);
                        iomObj.setobjectline(this.itfLine.getLineNumber());
                        if (this.td != null) {
                            AbstractClassDef aclass;
                            if (this.tag2class == null) {
                                this.tag2class = ModelUtilities.getTagMap(this.td);
                            }
                            if (!this.tag2class.containsKey(iliQName)) {
                                throw new IoxException(this.itfLine.getLineNumber(), "unknown class <" + iliQName + ">");
                            }
                            Object aclassObj = this.tag2class.get(iliQName);
                            if (aclassObj instanceof AbstractClassDef) {
                                aclass = (AbstractClassDef)aclassObj;
                                polylineattrs = ModelUtilities.getPolylineAttrs(aclass);
                            } else {
                                surfaceOrAreaAttr = (AttributeDef)aclassObj;
                                aclass = (AbstractClassDef)surfaceOrAreaAttr.getContainer();
                                polylineattrs = new ArrayList<AttributeDef>();
                                polylineattrs.add(surfaceOrAreaAttr);
                            }
                            polyAttrIdx = 0;
                            if (surfaceOrAreaAttr != null) {
                                int startLineAttr;
                                if (surfaceOrAreaAttr.getDomainResolvingAliases() instanceof SurfaceType) {
                                    String maintableref = ModelUtilities.getHelperTableMainTableRef(surfaceOrAreaAttr);
                                    IomObject structvalue = this.createIomObject("REF", null);
                                    String ref = propv[1];
                                    if (this.tid2tid != null) {
                                        String oldRef = String.valueOf(aclass.getName()) + ":" + ref;
                                        if (!this.tid2tid.containsKey(oldRef)) {
                                            throw new IoxException(this.itfLine.getLineNumber(), "dangling reference <" + oldRef + ">");
                                        }
                                        ref = (String)this.tid2tid.get(oldRef);
                                    }
                                    structvalue.setobjectrefoid(ref);
                                    iomObj.addattrobj(maintableref, structvalue);
                                    startLineAttr = 2;
                                } else {
                                    startLineAttr = 1;
                                }
                                SurfaceOrAreaType saType = (SurfaceOrAreaType)surfaceOrAreaAttr.getDomainResolvingAliases();
                                Table lineAttrTable = saType.getLineAttributeStructure();
                                if (lineAttrTable != null) {
                                    this.setPrimAttrs(iomObj, propv, ModelUtilities.getIli1AttrList(lineAttrTable), startLineAttr);
                                }
                            } else {
                                this.setPrimAttrs(iomObj, propv, ModelUtilities.getIli1AttrList(aclass), 1);
                            }
                        }
                        event = new ObjectEvent(iomObj);
                        if (this.scanner.nextKind() == 14) {
                            this.state = 100;
                            continue block14;
                        }
                        if (this.scanner.nextKind() == 15) {
                            this.state = 100;
                            continue block14;
                        }
                        return event;
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "OBJE, PERI or ETAB expected");
                }
                case 62: {
                    if (kind == 11) {
                        this.className = null;
                        this.state = 50;
                        continue block14;
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "ETAB expected");
                }
                case 100: {
                    IomObject coordValue;
                    String[] propv;
                    if (kind == 14) {
                        if (this.td != null) {
                            propv = this.splitItfLine(this.itfLine.getContent());
                            AttributeDef polyAttr = (AttributeDef)polylineattrs.get(polyAttrIdx);
                            Type type = Type.findReal(polyAttr.getDomain());
                            Domain controlPointDomain = ((LineType)type).getControlPointDomain();
                            CoordType coordType = (CoordType)Type.findReal(controlPointDomain.getType());
                            polyAttrIs3D = coordType.getDimensions().length == 3;
                            String polyAttrName = null;
                            polyAttrName = surfaceOrAreaAttr != null && polyAttrIdx == 0 ? ModelUtilities.getHelperTableGeomAttrName(surfaceOrAreaAttr) : polyAttr.getName();
                            IomObject polylineValue = this.createIomObject("POLYLINE", null);
                            iomObj.addattrobj(polyAttrName, polylineValue);
                            polyAttrSequence = this.createIomObject("SEGMENTS", null);
                            polylineValue.addattrobj("sequence", polyAttrSequence);
                            IomObject coordValue2 = this.createIomObject("COORD", null);
                            coordValue2.setattrvalue("C1", propv[0]);
                            coordValue2.setattrvalue("C2", propv[1]);
                            if (polyAttrIs3D && propv.length >= 3) {
                                coordValue2.setattrvalue("C3", propv[2]);
                            }
                            polyAttrSequence.addattrobj("segment", coordValue2);
                        }
                        this.state = 100;
                        continue block14;
                    }
                    if (kind == 16) {
                        if (this.td != null) {
                            propv = this.splitItfLine(this.itfLine.getContent());
                            coordValue = this.createIomObject("COORD", null);
                            coordValue.setattrvalue("C1", propv[0]);
                            coordValue.setattrvalue("C2", propv[1]);
                            if (polyAttrIs3D && propv.length >= 3) {
                                coordValue.setattrvalue("C3", propv[2]);
                            }
                            polyAttrSequence.addattrobj("segment", coordValue);
                        }
                        this.state = 100;
                        continue block14;
                    }
                    if (kind == 17) {
                        if (this.td != null) {
                            propv = this.splitItfLine(this.itfLine.getContent());
                            coordValue = this.createIomObject("ARC", null);
                            coordValue.setattrvalue("A1", propv[0]);
                            coordValue.setattrvalue("A2", propv[1]);
                            polyAttrSequence.addattrobj("segment", coordValue);
                        }
                        this.state = 101;
                        continue block14;
                    }
                    if (kind == 15) {
                        ++polyAttrIdx;
                        polyAttrSequence = null;
                        if (this.scanner.nextKind() == 14) {
                            this.state = 100;
                            continue block14;
                        }
                        if (this.scanner.nextKind() == 15) {
                            this.state = 100;
                            continue block14;
                        }
                        this.state = 60;
                        return event;
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "STPT, LIPT, ARCP or ELIN expected");
                }
                case 101: {
                    IomObject coordValue;
                    String[] propv;
                    if (kind != 16) {
                        throw new IoxException(this.itfLine.getLineNumber(), "LIPT expected");
                    }
                    if (this.td != null) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        coordValue = null;
                        int last = polyAttrSequence.getattrvaluecount("segment") - 1;
                        coordValue = polyAttrSequence.getattrobj("segment", last);
                        coordValue.setattrvalue("C1", propv[0]);
                        coordValue.setattrvalue("C2", propv[1]);
                        if (polyAttrIs3D && propv.length >= 3) {
                            coordValue.setattrvalue("C3", propv[2]);
                        }
                    }
                    this.state = 100;
                    continue block14;
                }
                case 120: {
                    String[] propv;
                    if (kind == 6) {
                        propv = this.splitItfLine(this.itfLine.getContent());
                        this.modelName = propv[0];
                        if (this.modelName == null) {
                            throw new IoxException(this.itfLine.getLineNumber(), "missing model name");
                        }
                        this.state = 41;
                        continue block14;
                    }
                    if (kind == 4 || kind == 0) {
                        this.state = 0;
                        return new EndTransferEvent();
                    }
                    throw new IoxException(this.itfLine.getLineNumber(), "MODL or ENDE expected");
                }
            }
            break;
        }
        throw new IllegalStateException("line " + this.itfLine.getLineNumber() + ", state " + this.state);
    }

    private void setPrimAttrs(IomObject iomObj, String[] prop, List attrlist, int propStartIdx) throws IoxException {
        for (ViewableTransferElement obj : attrlist) {
            String oldRef;
            String ref;
            IomObject structvalue;
            if (obj.obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)obj.obj;
                Type type = Type.findReal(attr.getDomain());
                if (type instanceof LineType && !(type instanceof AreaType)) continue;
                if (type instanceof AreaType) {
                    if (prop.length > propStartIdx + 1) {
                        if (prop[propStartIdx] != null && prop[propStartIdx + 1] != null) {
                            IomObject coord = this.createIomObject("COORD", null);
                            coord.setattrvalue("C1", prop[propStartIdx++]);
                            coord.setattrvalue("C2", prop[propStartIdx++]);
                            iomObj.addattrobj(attr.getName(), coord);
                            continue;
                        }
                        propStartIdx += 2;
                        continue;
                    }
                    propStartIdx += 2;
                    continue;
                }
                if (type instanceof CoordType) {
                    boolean is3D = ((CoordType)type).getDimensions().length == 3;
                    if (prop.length > propStartIdx + (is3D ? 2 : 1)) {
                        if (!(prop[propStartIdx] == null || prop[propStartIdx + 1] == null || is3D && prop[propStartIdx + 2] == null)) {
                            IomObject coord = this.createIomObject("COORD", null);
                            coord.setattrvalue("C1", prop[propStartIdx++]);
                            coord.setattrvalue("C2", prop[propStartIdx++]);
                            if (is3D && prop.length >= propStartIdx + 1) {
                                coord.setattrvalue("C3", prop[propStartIdx++]);
                            }
                            iomObj.addattrobj(attr.getName(), coord);
                            continue;
                        }
                        propStartIdx += is3D ? 3 : 2;
                        continue;
                    }
                    propStartIdx += is3D ? 3 : 2;
                    continue;
                }
                if (type instanceof EnumerationType) {
                    if (prop.length > propStartIdx && prop[propStartIdx] != null) {
                        String iliQName;
                        String itfCode;
                        if ((itfCode = prop[propStartIdx++]).charAt(0) == '0' && itfCode.length() > 1) {
                            try {
                                int code = Integer.parseInt(itfCode);
                                itfCode = Integer.toString(code);
                            }
                            catch (NumberFormatException code) {
                                // empty catch block
                            }
                        }
                        if (this.readEnumValAsItfCode) {
                            iliQName = this.mapItfCode2XtfCode((EnumerationType)type, itfCode);
                            if (iliQName == null) {
                                EhiLogger.logAdaption(String.valueOf(iomObj.getobjecttag()) + " " + iomObj.getobjectoid() + ": unexpected code <" + itfCode + "> for attribute " + attr.getName() + "; unmodified read");
                            }
                            iomObj.setattrvalue(attr.getName(), itfCode);
                            continue;
                        }
                        iliQName = this.mapItfCode2XtfCode((EnumerationType)type, itfCode);
                        if (iliQName == null) {
                            EhiLogger.logAdaption(String.valueOf(iomObj.getobjecttag()) + " " + iomObj.getobjectoid() + ": unexpected code <" + itfCode + "> for attribute " + attr.getName() + "; read without mapping");
                            iliQName = itfCode;
                        }
                        iomObj.setattrvalue(attr.getName(), iliQName);
                        continue;
                    }
                    ++propStartIdx;
                    continue;
                }
                if (type instanceof TextType) {
                    if (prop.length > propStartIdx && prop[propStartIdx] != null) {
                        String txt = prop[propStartIdx++];
                        txt = txt.replace(this.blankCode, ' ');
                        iomObj.setattrvalue(attr.getName(), txt);
                        continue;
                    }
                    ++propStartIdx;
                    continue;
                }
                if (prop.length > propStartIdx && prop[propStartIdx] != null) {
                    iomObj.setattrvalue(attr.getName(), prop[propStartIdx++]);
                    continue;
                }
                ++propStartIdx;
                continue;
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded) {
                structvalue = this.createIomObject("REF", null);
                ref = prop[propStartIdx++];
                if (this.tid2tid != null) {
                    oldRef = String.valueOf(role.getDestination().getName()) + ":" + ref;
                    if (!this.tid2tid.containsKey(oldRef)) {
                        throw new IoxException(this.itfLine.getLineNumber(), "dangling reference <" + oldRef + ">");
                    }
                    ref = (String)this.tid2tid.get(oldRef);
                }
                structvalue.setobjectrefoid(ref);
                iomObj.addattrobj(role.getName(), structvalue);
                continue;
            }
            if (prop.length > propStartIdx && prop[propStartIdx] != null) {
                structvalue = this.createIomObject("REF", null);
                ref = prop[propStartIdx++];
                if (this.tid2tid != null) {
                    oldRef = String.valueOf(role.getDestination().getName()) + ":" + ref;
                    if (!this.tid2tid.containsKey(oldRef)) {
                        throw new IoxException(this.itfLine.getLineNumber(), "dangling reference <" + oldRef + ">");
                    }
                    ref = (String)this.tid2tid.get(oldRef);
                }
                structvalue.setobjectrefoid(ref);
                iomObj.addattrobj(role.getName(), structvalue);
                continue;
            }
            ++propStartIdx;
        }
    }

    private String[] splitItfLine(String line) {
        String[] ret = line.trim().split("\\s+");
        int i = 0;
        while (i < ret.length) {
            if (ret[i] != null && ret[i].length() == 0) {
                ret[i] = null;
            }
            if (ret[i] != null && ret[i].equals(this.undefinedCode)) {
                ret[i] = null;
            }
            ++i;
        }
        return ret;
    }

    public void setModel(TransferDescription td) {
        this.td = td;
        try {
            if (td != null && td.getIli1Format() != null) {
                this.undefinedCode = ModelUtilities.code2string(td.getIli1Format().undefinedCode);
                this.blankCode = ModelUtilities.code2string(td.getIli1Format().blankCode).charAt(0);
                this.continueCode = ModelUtilities.code2string(td.getIli1Format().continueCode).charAt(0);
            }
            this.scanner.setContinueCode(this.continueCode);
        }
        catch (UnsupportedEncodingException ex) {
            EhiLogger.logError(ex);
        }
    }

    @Override
    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    @Override
    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    @Override
    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    public void setReadEnumValAsItfCode(boolean val) {
        this.readEnumValAsItfCode = val;
    }

    public boolean isReadEnumValAsItfCode() {
        return this.readEnumValAsItfCode;
    }

    static String dumpobject(IomObject obj) {
        StringBuffer ret = new StringBuffer();
        boolean doout = true;
        String className = obj.getobjecttag();
        String oid = obj.getobjectoid();
        ret.append(className);
        if (oid != null) {
            ret.append(" oid " + oid);
        }
        ret.append(" {");
        String sep = "";
        int i = 0;
        while (i < obj.getattrcount()) {
            String propName = obj.getattrname(i);
            String value = obj.getattrvalue(propName);
            if (value == null) {
                IomObject structvalue = obj.getattrobj(propName, 0);
                if (structvalue != null) {
                    long orderPos;
                    String refoid = structvalue.getobjectrefoid();
                    if (structvalue.getobjecttag() != null) {
                        ret.append(String.valueOf(sep) + propName + " ");
                        if (refoid != null) {
                            orderPos = structvalue.getobjectreforderpos();
                            if (orderPos != 0L) {
                                ret.append("-> " + refoid + ", ORDER_POS " + orderPos + " ");
                            } else {
                                ret.append("-> " + refoid + " ");
                            }
                        }
                        ret.append(ItfReader.dumpobject(structvalue));
                        if (refoid == null) {
                            int propc = obj.getattrvaluecount(propName);
                            int propi = 1;
                            while (propi < propc) {
                                structvalue = obj.getattrobj(propName, propi);
                                ret.append(", " + ItfReader.dumpobject(structvalue));
                                ++propi;
                            }
                        }
                    } else if (refoid != null) {
                        orderPos = structvalue.getobjectreforderpos();
                        if (orderPos != 0L) {
                            ret.append(String.valueOf(sep) + propName + " -> " + refoid + ", ORDER_POS " + orderPos);
                        } else {
                            ret.append(String.valueOf(sep) + propName + " -> " + refoid);
                        }
                    }
                    sep = ", ";
                }
            } else {
                ret.append(String.valueOf(sep) + propName + " " + value);
                sep = ", ";
            }
            ++i;
        }
        ret.append("}");
        return ret.toString();
    }

    private String mapItfCode2XtfCode(EnumerationType type, String xtfCode) {
        return this.enumMapper.mapItfCode2XtfCode(type, xtfCode);
    }

    public boolean isRenumberTids() {
        return this.renumberTids;
    }

    public void setRenumberTids(boolean renumberTids) {
        this.renumberTids = renumberTids;
    }

    private String newTid() {
        return Long.toString(this.tid++);
    }
}

