/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.PropertyDesc;

public class ResourcesDesc {
    private final Locale[] locales;
    private final String[] os;
    private final String[] arch;
    private final JNLPFile jnlpFile;
    private final List<Object> resources = new ArrayList<Object>();

    public ResourcesDesc(JNLPFile jnlpFile, Locale[] locales, String[] os, String[] arch) {
        this.jnlpFile = jnlpFile;
        this.locales = locales;
        this.os = os;
        this.arch = arch;
    }

    public JREDesc[] getJREs() {
        List<JREDesc> lresources = this.getResources(JREDesc.class);
        return lresources.toArray(new JREDesc[lresources.size()]);
    }

    public static JARDesc getMainJAR(JARDesc[] jars) {
        return ResourcesDesc.getMainJAR(Arrays.asList(jars));
    }

    public static JARDesc getMainJAR(List<JARDesc> jars) {
        for (JARDesc jar : jars) {
            if (!jar.isMain()) continue;
            return jar;
        }
        if (jars.size() > 0) {
            return jars.get(0);
        }
        return null;
    }

    public JARDesc getMainJAR() {
        return ResourcesDesc.getMainJAR(this.getJARs());
    }

    public JARDesc[] getJARs() {
        List<JARDesc> lresources = this.getResources(JARDesc.class);
        return lresources.toArray(new JARDesc[lresources.size()]);
    }

    public JARDesc[] getJARs(String partName) {
        List<JARDesc> lresources = this.getResources(JARDesc.class);
        int i = lresources.size();
        while (i-- > 0) {
            JARDesc jar = lresources.get(i);
            if (("" + jar.getPart()).equals("" + partName)) continue;
            lresources.remove(i);
        }
        return lresources.toArray(new JARDesc[lresources.size()]);
    }

    public ExtensionDesc[] getExtensions() {
        List<ExtensionDesc> lresources = this.getResources(ExtensionDesc.class);
        return lresources.toArray(new ExtensionDesc[lresources.size()]);
    }

    public PackageDesc[] getPackages() {
        List<PackageDesc> lresources = this.getResources(PackageDesc.class);
        return lresources.toArray(new PackageDesc[lresources.size()]);
    }

    public PackageDesc[] getPackages(String className) {
        List<PackageDesc> lresources = this.getResources(PackageDesc.class);
        int i = lresources.size();
        while (i-- > 0) {
            PackageDesc pk = lresources.get(i);
            if (pk.matches(className)) continue;
            lresources.remove(i);
        }
        return lresources.toArray(new PackageDesc[lresources.size()]);
    }

    public PropertyDesc[] getProperties() {
        List<PropertyDesc> lresources = this.getResources(PropertyDesc.class);
        return lresources.toArray(new PropertyDesc[lresources.size()]);
    }

    public Map<String, String> getPropertiesMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<PropertyDesc> lresources = this.getResources(PropertyDesc.class);
        for (PropertyDesc prop : lresources) {
            properties.put(prop.getKey(), prop.getValue());
        }
        return properties;
    }

    public String[] getOS() {
        return this.os;
    }

    public String[] getArch() {
        return this.arch;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public JNLPFile getJNLPFile() {
        return this.jnlpFile;
    }

    public <T> List<T> getResources(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object resource : this.resources) {
            if (!type.isAssignableFrom(resource.getClass())) continue;
            result.add(type.cast(resource));
        }
        return result;
    }

    public void addResource(Object resource) {
        if (resource == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.resources.add(resource);
    }
}

