/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;

public class DocValuesTermsQuery
extends Query {
    private final String field;
    private final BytesRef[] terms;

    public DocValuesTermsQuery(String field, Collection<BytesRef> terms) {
        this.field = Objects.requireNonNull(field);
        Objects.requireNonNull(terms, "Collection of terms must not be null");
        this.terms = terms.toArray(new BytesRef[terms.size()]);
        ArrayUtil.timSort((Comparable[])this.terms);
    }

    public DocValuesTermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public DocValuesTermsQuery(String field, final String ... terms) {
        this(field, (Collection<BytesRef>)new AbstractList<BytesRef>(){

            @Override
            public BytesRef get(int index) {
                return new BytesRef((CharSequence)terms[index]);
            }

            @Override
            public int size() {
                return terms.length;
            }
        });
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesTermsQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DocValuesTermsQuery other) {
        return this.field.equals(other.field) && Arrays.equals(this.terms, other.terms);
    }

    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.field, Arrays.asList(this.terms));
    }

    public String toString(String defaultField) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field).append(": [");
        for (BytesRef term : this.terms) {
            sb.append(term).append(", ");
        }
        if (this.terms.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append(']').toString();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                final SortedSetDocValues values = DocValues.getSortedSet((LeafReader)context.reader(), (String)DocValuesTermsQuery.this.field);
                final LongBitSet bits = new LongBitSet(values.getValueCount());
                for (BytesRef term : DocValuesTermsQuery.this.terms) {
                    long ord = values.lookupTerm(term);
                    if (ord < 0L) continue;
                    bits.set(ord);
                }
                return new Bits(){

                    public boolean get(int doc) {
                        values.setDocument(doc);
                        long ord = values.nextOrd();
                        while (ord != -1L) {
                            if (bits.get(ord)) {
                                return true;
                            }
                            ord = values.nextOrd();
                        }
                        return false;
                    }

                    public int length() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }
}

