/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.BitSet;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Executable;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.antlr.Walker;
import org.elasticsearch.painless.node.SSource;
import org.objectweb.asm.util.Printer;

final class Compiler {
    static int MAXIMUM_SOURCE_LENGTH = 16384;
    private static final CodeSource CODESOURCE;

    static Executable compile(Loader loader, String name, String source, CompilerSettings settings) {
        if (source.length() > MAXIMUM_SOURCE_LENGTH) {
            throw new IllegalArgumentException("Scripts may be no longer than " + MAXIMUM_SOURCE_LENGTH + " characters.  The passed in script is " + source.length() + " characters.  Consider using a plugin if a script longer than this length is a requirement.");
        }
        SSource root = Walker.buildPainlessTree(name, source, settings, null);
        root.analyze();
        root.write();
        try {
            Class<? extends Executable> clazz = loader.define(WriterConstants.CLASS_NAME, root.getBytes());
            Constructor<? extends Executable> constructor = clazz.getConstructor(String.class, String.class, BitSet.class);
            return constructor.newInstance(name, source, root.getStatements());
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the script [" + name + "].", exception);
        }
    }

    static byte[] compile(String name, String source, CompilerSettings settings, Printer debugStream) {
        if (source.length() > MAXIMUM_SOURCE_LENGTH) {
            throw new IllegalArgumentException("Scripts may be no longer than " + MAXIMUM_SOURCE_LENGTH + " characters.  The passed in script is " + source.length() + " characters.  Consider using a plugin if a script longer than this length is a requirement.");
        }
        SSource root = Walker.buildPainlessTree(name, source, settings, debugStream);
        root.analyze();
        root.write();
        return root.getBytes();
    }

    private Compiler() {
    }

    static {
        try {
            CODESOURCE = new CodeSource(new URL("file:/untrusted"), (Certificate[])null);
        }
        catch (MalformedURLException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    static final class Loader
    extends SecureClassLoader {
        Loader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends Executable> define(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE).asSubclass(Executable.class);
        }
    }
}

