/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.RoutingException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpException;
import org.elasticsearch.index.AlreadyExpiredException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.snapshots.IndexShardRestoreException;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndexPrimaryShardNotAllocatedException;
import org.elasticsearch.indices.IndexTemplateAlreadyExistsException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ActionTransportException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportSerializationException;

public class ElasticsearchException
extends RuntimeException
implements ToXContent,
Writeable {
    public static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    public static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String INDEX_HEADER_KEY = "es.index";
    private static final String INDEX_HEADER_KEY_UUID = "es.index_uuid";
    private static final String SHARD_HEADER_KEY = "es.shard";
    private static final String RESOURCE_HEADER_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_HEADER_ID_KEY = "es.resource.id";
    private static final Map<Integer, FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException>> ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
    private static final Map<Class<? extends ElasticsearchException>, ElasticsearchExceptionHandle> CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ElasticsearchException(Throwable cause) {
        super(cause);
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        ElasticsearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
    }

    public void addHeader(String key, String ... value) {
        this.headers.put(key, Arrays.asList(value));
    }

    public void addHeader(String key, List<String> value) {
        this.headers.put(key, value);
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        ElasticsearchException.writeStackTraces(this, out);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return elasticsearchException.apply(input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception) {
        return CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.containsKey(exception);
    }

    static Set<Class<? extends ElasticsearchException>> getRegisteredKeys() {
        return CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.keySet();
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return ElasticsearchException.CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            ElasticsearchException.toXContent(builder, params, this);
        } else {
            builder.field("type", this.getExceptionName());
            builder.field("reason", this.getMessage());
            for (String key : this.headers.keySet()) {
                if (!key.startsWith("es.")) continue;
                List<String> values = this.headers.get(key);
                this.xContentHeader(builder, key.substring("es.".length()), values);
            }
            this.innerToXContent(builder, params);
            this.renderHeader(builder, params);
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field("stack_trace", ExceptionsHelper.stackTrace(this));
            }
        }
        return builder;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.causeToXContent(builder, params);
    }

    protected void causeToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable cause = this.getCause();
        if (cause != null && !params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false)) {
            builder.field("caused_by");
            builder.startObject();
            ElasticsearchException.toXContent(builder, params, cause);
            builder.endObject();
        }
    }

    protected final void renderHeader(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasHeader = false;
        for (String key : this.headers.keySet()) {
            if (key.startsWith("es.")) continue;
            if (!hasHeader) {
                builder.startObject("header");
                hasHeader = true;
            }
            List<String> values = this.headers.get(key);
            this.xContentHeader(builder, key, values);
        }
        if (hasHeader) {
            builder.endObject();
        }
    }

    private void xContentHeader(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    public static void toXContent(XContentBuilder builder, ToXContent.Params params, Throwable ex) throws IOException {
        if ((ex = ExceptionsHelper.unwrapCause(ex)) instanceof ElasticsearchException) {
            ((ElasticsearchException)ex).toXContent(builder, params);
        } else {
            builder.field("type", ElasticsearchException.getExceptionName(ex));
            builder.field("reason", ex.getMessage());
            if (ex.getCause() != null) {
                builder.field("caused_by");
                builder.startObject();
                ElasticsearchException.toXContent(builder, params, ex.getCause());
                builder.endObject();
            }
            if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
                builder.field("stack_trace", ExceptionsHelper.stackTrace(ex));
            }
        }
    }

    public ElasticsearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).guessRootCauses();
        }
        return new ElasticsearchException[]{this};
    }

    public static ElasticsearchException[] guessRootCauses(Throwable t) {
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof ElasticsearchException) {
            return ((ElasticsearchException)ex).guessRootCauses();
        }
        return new ElasticsearchException[]{new ElasticsearchException(t.getMessage(), t, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return ElasticsearchException.toUnderscoreCase(simpleName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.headers.containsKey(INDEX_HEADER_KEY)) {
            builder.append(this.getIndex());
            if (this.headers.containsKey(SHARD_HEADER_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(ExceptionsHelper.detailedMessage(this).trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        int stackTraceElements = in.readVInt();
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElements];
        for (int i = 0; i < stackTraceElements; ++i) {
            String declaringClasss = in.readString();
            String fileName = in.readOptionalString();
            String methodName = in.readString();
            int lineNumber = in.readVInt();
            stackTrace[i] = new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }
        throwable.setStackTrace(stackTrace);
        int numSuppressed = in.readVInt();
        for (int i = 0; i < numSuppressed; ++i) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out) throws IOException {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        out.writeVInt(stackTrace.length);
        for (StackTraceElement element : stackTrace) {
            out.writeString(element.getClassName());
            out.writeOptionalString(element.getFileName());
            out.writeString(element.getMethodName());
            out.writeVInt(element.getLineNumber());
        }
        Throwable[] suppressed = throwable.getSuppressed();
        out.writeVInt(suppressed.length);
        for (Throwable t : suppressed) {
            out.writeException(t);
        }
        return throwable;
    }

    public Index getIndex() {
        List<String> index = this.getHeader(INDEX_HEADER_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getHeader(INDEX_HEADER_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getHeader(SHARD_HEADER_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addHeader(INDEX_HEADER_KEY, index.getName());
            this.addHeader(INDEX_HEADER_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addHeader(SHARD_HEADER_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setShard(String index, int shardId) {
        this.setIndex(index);
        this.addHeader(SHARD_HEADER_KEY, Integer.toString(shardId));
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addHeader(RESOURCE_HEADER_ID_KEY, id);
        this.addHeader(RESOURCE_HEADER_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getHeader(RESOURCE_HEADER_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getHeader(RESOURCE_HEADER_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    public static void renderException(XContentBuilder builder, ToXContent.Params params, Exception e) throws IOException {
        builder.startObject("error");
        ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(e);
        builder.field("root_cause");
        builder.startArray();
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        ElasticsearchException.toXContent(builder, params, e);
        builder.endObject();
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    static interface FunctionThatThrowsIOException<T, R> {
        public R apply(T var1) throws IOException;
    }

    static enum ElasticsearchExceptionHandle {
        INDEX_SHARD_SNAPSHOT_FAILED_EXCEPTION(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0),
        DFS_PHASE_EXECUTION_EXCEPTION(DfsPhaseExecutionException.class, DfsPhaseExecutionException::new, 1),
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2),
        MASTER_NOT_DISCOVERED_EXCEPTION(MasterNotDiscoveredException.class, MasterNotDiscoveredException::new, 3),
        ELASTICSEARCH_SECURITY_EXCEPTION(ElasticsearchSecurityException.class, ElasticsearchSecurityException::new, 4),
        INDEX_SHARD_RESTORE_EXCEPTION(IndexShardRestoreException.class, IndexShardRestoreException::new, 5),
        INDEX_CLOSED_EXCEPTION(IndexClosedException.class, IndexClosedException::new, 6),
        BIND_HTTP_EXCEPTION(BindHttpException.class, BindHttpException::new, 7),
        REDUCE_SEARCH_PHASE_EXCEPTION(ReduceSearchPhaseException.class, ReduceSearchPhaseException::new, 8),
        NODE_CLOSED_EXCEPTION(NodeClosedException.class, NodeClosedException::new, 9),
        SNAPSHOT_FAILED_ENGINE_EXCEPTION(SnapshotFailedEngineException.class, SnapshotFailedEngineException::new, 10),
        SHARD_NOT_FOUND_EXCEPTION(ShardNotFoundException.class, ShardNotFoundException::new, 11),
        CONNECT_TRANSPORT_EXCEPTION(ConnectTransportException.class, ConnectTransportException::new, 12),
        NOT_SERIALIZABLE_TRANSPORT_EXCEPTION(NotSerializableTransportException.class, NotSerializableTransportException::new, 13),
        RESPONSE_HANDLER_FAILURE_TRANSPORT_EXCEPTION(ResponseHandlerFailureTransportException.class, ResponseHandlerFailureTransportException::new, 14),
        INDEX_CREATION_EXCEPTION(IndexCreationException.class, IndexCreationException::new, 15),
        INDEX_NOT_FOUND_EXCEPTION(IndexNotFoundException.class, IndexNotFoundException::new, 16),
        ILLEGAL_SHARD_ROUTING_STATE_EXCEPTION(IllegalShardRoutingStateException.class, IllegalShardRoutingStateException::new, 17),
        BROADCAST_SHARD_OPERATION_FAILED_EXCEPTION(BroadcastShardOperationFailedException.class, BroadcastShardOperationFailedException::new, 18),
        RESOURCE_NOT_FOUND_EXCEPTION(ResourceNotFoundException.class, ResourceNotFoundException::new, 19),
        ACTION_TRANSPORT_EXCEPTION(ActionTransportException.class, ActionTransportException::new, 20),
        ELASTICSEARCH_GENERATION_EXCEPTION(ElasticsearchGenerationException.class, ElasticsearchGenerationException::new, 21),
        INDEX_SHARD_STARTED_EXCEPTION(IndexShardStartedException.class, IndexShardStartedException::new, 23),
        SEARCH_CONTEXT_MISSING_EXCEPTION(SearchContextMissingException.class, SearchContextMissingException::new, 24),
        GENERAL_SCRIPT_EXCEPTION(GeneralScriptException.class, GeneralScriptException::new, 25),
        BATCH_OPERATION_EXCEPTION(TranslogRecoveryPerformer.BatchOperationException.class, TranslogRecoveryPerformer.BatchOperationException::new, 26),
        SNAPSHOT_CREATION_EXCEPTION(SnapshotCreationException.class, SnapshotCreationException::new, 27),
        DELETE_FAILED_ENGINE_EXCEPTION(DeleteFailedEngineException.class, DeleteFailedEngineException::new, 28),
        DOCUMENT_MISSING_EXCEPTION(DocumentMissingException.class, DocumentMissingException::new, 29),
        SNAPSHOT_EXCEPTION(SnapshotException.class, SnapshotException::new, 30),
        INVALID_ALIAS_NAME_EXCEPTION(InvalidAliasNameException.class, InvalidAliasNameException::new, 31),
        INVALID_INDEX_NAME_EXCEPTION(InvalidIndexNameException.class, InvalidIndexNameException::new, 32),
        INDEX_PRIMARY_SHARD_NOT_ALLOCATED_EXCEPTION(IndexPrimaryShardNotAllocatedException.class, IndexPrimaryShardNotAllocatedException::new, 33),
        TRANSPORT_EXCEPTION(TransportException.class, TransportException::new, 34),
        ELASTICSEARCH_PARSE_EXCEPTION(ElasticsearchParseException.class, ElasticsearchParseException::new, 35),
        SEARCH_EXCEPTION(SearchException.class, SearchException::new, 36),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37),
        INVALID_TYPE_NAME_EXCEPTION(InvalidTypeNameException.class, InvalidTypeNameException::new, 38),
        SNAPSHOT_RESTORE_EXCEPTION(SnapshotRestoreException.class, SnapshotRestoreException::new, 39),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40),
        INDEX_SHARD_CLOSED_EXCEPTION(IndexShardClosedException.class, IndexShardClosedException::new, 41),
        RECOVER_FILES_RECOVERY_EXCEPTION(RecoverFilesRecoveryException.class, RecoverFilesRecoveryException::new, 42),
        TRUNCATED_TRANSLOG_EXCEPTION(TruncatedTranslogException.class, TruncatedTranslogException::new, 43),
        RECOVERY_FAILED_EXCEPTION(RecoveryFailedException.class, RecoveryFailedException::new, 44),
        INDEX_SHARD_RELOCATED_EXCEPTION(IndexShardRelocatedException.class, IndexShardRelocatedException::new, 45),
        NODE_SHOULD_NOT_CONNECT_EXCEPTION(NodeShouldNotConnectException.class, NodeShouldNotConnectException::new, 46),
        INDEX_TEMPLATE_ALREADY_EXISTS_EXCEPTION(IndexTemplateAlreadyExistsException.class, IndexTemplateAlreadyExistsException::new, 47),
        TRANSLOG_CORRUPTED_EXCEPTION(TranslogCorruptedException.class, TranslogCorruptedException::new, 48),
        CLUSTER_BLOCK_EXCEPTION(ClusterBlockException.class, ClusterBlockException::new, 49),
        FETCH_PHASE_EXECUTION_EXCEPTION(FetchPhaseExecutionException.class, FetchPhaseExecutionException::new, 50),
        INDEX_SHARD_ALREADY_EXISTS_EXCEPTION(IndexShardAlreadyExistsException.class, IndexShardAlreadyExistsException::new, 51),
        VERSION_CONFLICT_ENGINE_EXCEPTION(VersionConflictEngineException.class, VersionConflictEngineException::new, 52),
        ENGINE_EXCEPTION(EngineException.class, EngineException::new, 53),
        NO_SUCH_NODE_EXCEPTION(NoSuchNodeException.class, NoSuchNodeException::new, 55),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56),
        INDEX_TEMPLATE_MISSING_EXCEPTION(IndexTemplateMissingException.class, IndexTemplateMissingException::new, 57),
        SEND_REQUEST_TRANSPORT_EXCEPTION(SendRequestTransportException.class, SendRequestTransportException::new, 58),
        ES_REJECTED_EXECUTION_EXCEPTION(EsRejectedExecutionException.class, EsRejectedExecutionException::new, 59),
        EARLY_TERMINATION_EXCEPTION(Lucene.EarlyTerminationException.class, Lucene.EarlyTerminationException::new, 60),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62),
        ALIAS_FILTER_PARSING_EXCEPTION(AliasFilterParsingException.class, AliasFilterParsingException::new, 63),
        GATEWAY_EXCEPTION(GatewayException.class, GatewayException::new, 65),
        INDEX_SHARD_NOT_RECOVERING_EXCEPTION(IndexShardNotRecoveringException.class, IndexShardNotRecoveringException::new, 66),
        HTTP_EXCEPTION(HttpException.class, HttpException::new, 67),
        ELASTICSEARCH_EXCEPTION(ElasticsearchException.class, ElasticsearchException::new, 68),
        SNAPSHOT_MISSING_EXCEPTION(SnapshotMissingException.class, SnapshotMissingException::new, 69),
        PRIMARY_MISSING_ACTION_EXCEPTION(PrimaryMissingActionException.class, PrimaryMissingActionException::new, 70),
        FAILED_NODE_EXCEPTION(FailedNodeException.class, FailedNodeException::new, 71),
        SEARCH_PARSE_EXCEPTION(SearchParseException.class, SearchParseException::new, 72),
        CONCURRENT_SNAPSHOT_EXECUTION_EXCEPTION(ConcurrentSnapshotExecutionException.class, ConcurrentSnapshotExecutionException::new, 73),
        BLOB_STORE_EXCEPTION(BlobStoreException.class, BlobStoreException::new, 74),
        INCOMPATIBLE_CLUSTER_STATE_VERSION_EXCEPTION(IncompatibleClusterStateVersionException.class, IncompatibleClusterStateVersionException::new, 75),
        RECOVERY_ENGINE_EXCEPTION(RecoveryEngineException.class, RecoveryEngineException::new, 76),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77),
        TIMESTAMP_PARSING_EXCEPTION(TimestampParsingException.class, TimestampParsingException::new, 78),
        ROUTING_MISSING_EXCEPTION(RoutingMissingException.class, RoutingMissingException::new, 79),
        INDEX_FAILED_ENGINE_EXCEPTION(IndexFailedEngineException.class, IndexFailedEngineException::new, 80),
        INDEX_SHARD_RESTORE_FAILED_EXCEPTION(IndexShardRestoreFailedException.class, IndexShardRestoreFailedException::new, 81),
        REPOSITORY_EXCEPTION(RepositoryException.class, RepositoryException::new, 82),
        RECEIVE_TIMEOUT_TRANSPORT_EXCEPTION(ReceiveTimeoutTransportException.class, ReceiveTimeoutTransportException::new, 83),
        NODE_DISCONNECTED_EXCEPTION(NodeDisconnectedException.class, NodeDisconnectedException::new, 84),
        ALREADY_EXPIRED_EXCEPTION(AlreadyExpiredException.class, AlreadyExpiredException::new, 85),
        AGGREGATION_EXECUTION_EXCEPTION(AggregationExecutionException.class, AggregationExecutionException::new, 86),
        INVALID_INDEX_TEMPLATE_EXCEPTION(InvalidIndexTemplateException.class, InvalidIndexTemplateException::new, 88),
        REFRESH_FAILED_ENGINE_EXCEPTION(RefreshFailedEngineException.class, RefreshFailedEngineException::new, 90),
        AGGREGATION_INITIALIZATION_EXCEPTION(AggregationInitializationException.class, AggregationInitializationException::new, 91),
        DELAY_RECOVERY_EXCEPTION(DelayRecoveryException.class, DelayRecoveryException::new, 92),
        NO_NODE_AVAILABLE_EXCEPTION(NoNodeAvailableException.class, NoNodeAvailableException::new, 94),
        INVALID_SNAPSHOT_NAME_EXCEPTION(InvalidSnapshotNameException.class, InvalidSnapshotNameException::new, 96),
        ILLEGAL_INDEX_SHARD_STATE_EXCEPTION(IllegalIndexShardStateException.class, IllegalIndexShardStateException::new, 97),
        INDEX_SHARD_SNAPSHOT_EXCEPTION(IndexShardSnapshotException.class, IndexShardSnapshotException::new, 98),
        INDEX_SHARD_NOT_STARTED_EXCEPTION(IndexShardNotStartedException.class, IndexShardNotStartedException::new, 99),
        SEARCH_PHASE_EXECUTION_EXCEPTION(SearchPhaseExecutionException.class, SearchPhaseExecutionException::new, 100),
        ACTION_NOT_FOUND_TRANSPORT_EXCEPTION(ActionNotFoundTransportException.class, ActionNotFoundTransportException::new, 101),
        TRANSPORT_SERIALIZATION_EXCEPTION(TransportSerializationException.class, TransportSerializationException::new, 102),
        REMOTE_TRANSPORT_EXCEPTION(RemoteTransportException.class, RemoteTransportException::new, 103),
        ENGINE_CREATION_FAILURE_EXCEPTION(EngineCreationFailureException.class, EngineCreationFailureException::new, 104),
        ROUTING_EXCEPTION(RoutingException.class, RoutingException::new, 105),
        INDEX_SHARD_RECOVERY_EXCEPTION(IndexShardRecoveryException.class, IndexShardRecoveryException::new, 106),
        REPOSITORY_MISSING_EXCEPTION(RepositoryMissingException.class, RepositoryMissingException::new, 107),
        DOCUMENT_SOURCE_MISSING_EXCEPTION(DocumentSourceMissingException.class, DocumentSourceMissingException::new, 109),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111),
        BIND_TRANSPORT_EXCEPTION(BindTransportException.class, BindTransportException::new, 112),
        ALIASES_NOT_FOUND_EXCEPTION(AliasesNotFoundException.class, AliasesNotFoundException::new, 113),
        INDEX_SHARD_RECOVERING_EXCEPTION(IndexShardRecoveringException.class, IndexShardRecoveringException::new, 114),
        TRANSLOG_EXCEPTION(TranslogException.class, TranslogException::new, 115),
        PROCESS_CLUSTER_EVENT_TIMEOUT_EXCEPTION(ProcessClusterEventTimeoutException.class, ProcessClusterEventTimeoutException::new, 116),
        RETRY_ON_PRIMARY_EXCEPTION(ReplicationOperation.RetryOnPrimaryException.class, ReplicationOperation.RetryOnPrimaryException::new, 117),
        ELASTICSEARCH_TIMEOUT_EXCEPTION(ElasticsearchTimeoutException.class, ElasticsearchTimeoutException::new, 118),
        QUERY_PHASE_EXECUTION_EXCEPTION(QueryPhaseExecutionException.class, QueryPhaseExecutionException::new, 119),
        REPOSITORY_VERIFICATION_EXCEPTION(RepositoryVerificationException.class, RepositoryVerificationException::new, 120),
        INVALID_AGGREGATION_PATH_EXCEPTION(InvalidAggregationPathException.class, InvalidAggregationPathException::new, 121),
        INDEX_ALREADY_EXISTS_EXCEPTION(IndexAlreadyExistsException.class, IndexAlreadyExistsException::new, 123),
        HTTP_ON_TRANSPORT_EXCEPTION(TcpTransport.HttpOnTransportException.class, TcpTransport.HttpOnTransportException::new, 125),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126),
        SEARCH_CONTEXT_EXCEPTION(SearchContextException.class, SearchContextException::new, 127),
        SEARCH_SOURCE_BUILDER_EXCEPTION(SearchSourceBuilderException.class, SearchSourceBuilderException::new, 128),
        ENGINE_CLOSED_EXCEPTION(EngineClosedException.class, EngineClosedException::new, 129),
        NO_SHARD_AVAILABLE_ACTION_EXCEPTION(NoShardAvailableActionException.class, NoShardAvailableActionException::new, 130),
        UNAVAILABLE_SHARDS_EXCEPTION(UnavailableShardsException.class, UnavailableShardsException::new, 131),
        FLUSH_FAILED_ENGINE_EXCEPTION(FlushFailedEngineException.class, FlushFailedEngineException::new, 132),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133),
        NODE_NOT_CONNECTED_EXCEPTION(NodeNotConnectedException.class, NodeNotConnectedException::new, 134),
        STRICT_DYNAMIC_MAPPING_EXCEPTION(StrictDynamicMappingException.class, StrictDynamicMappingException::new, 135),
        RETRY_ON_REPLICA_EXCEPTION(TransportReplicationAction.RetryOnReplicaException.class, TransportReplicationAction.RetryOnReplicaException::new, 136),
        TYPE_MISSING_EXCEPTION(TypeMissingException.class, TypeMissingException::new, 137),
        FAILED_TO_COMMIT_CLUSTER_STATE_EXCEPTION(Discovery.FailedToCommitClusterStateException.class, Discovery.FailedToCommitClusterStateException::new, 140),
        QUERY_SHARD_EXCEPTION(QueryShardException.class, QueryShardException::new, 141),
        NO_LONGER_PRIMARY_SHARD_EXCEPTION(ShardStateAction.NoLongerPrimaryShardException.class, ShardStateAction.NoLongerPrimaryShardException::new, 142),
        SCRIPT_EXCEPTION(ScriptException.class, ScriptException::new, 143),
        NOT_MASTER_EXCEPTION(NotMasterException.class, NotMasterException::new, 144),
        STATUS_EXCEPTION(ElasticsearchStatusException.class, ElasticsearchStatusException::new, 145);

        final Class<? extends ElasticsearchException> exceptionClass;
        final FunctionThatThrowsIOException<StreamInput, ? extends ElasticsearchException> constructor;
        final int id;

        private <E extends ElasticsearchException> ElasticsearchExceptionHandle(Class<E> exceptionClass, FunctionThatThrowsIOException<StreamInput, E> constructor, int id) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.id = id;
        }
    }
}

