/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportService;

public class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final Map<Action, TransportActionNodeProxy> proxies;

    public TransportProxyClient(Settings settings, TransportService transportService, TransportClientNodesService nodesService, List<GenericAction> actions) {
        this.nodesService = nodesService;
        HashMap proxies = new HashMap();
        for (GenericAction action : actions) {
            if (!(action instanceof Action)) continue;
            proxies.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.proxies = Collections.unmodifiableMap(proxies);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        TransportActionNodeProxy proxy = this.proxies.get(action);
        this.nodesService.execute((n, l) -> proxy.execute(n, request, l), listener);
    }
}

