/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class Decision
implements ToXContent {
    public static final Decision ALWAYS = new Single(Type.YES);
    public static final Decision YES = new Single(Type.YES);
    public static final Decision NO = new Single(Type.NO);
    public static final Decision THROTTLE = new Single(Type.THROTTLE);

    public static Decision single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
        return new Single(type, label, explanation, explanationParams);
    }

    public static void writeTo(Decision decision, StreamOutput out) throws IOException {
        if (decision instanceof Multi) {
            out.writeBoolean(true);
            out.writeVInt(((Multi)decision).decisions.size());
            for (Decision d : ((Multi)decision).decisions) {
                Decision.writeTo(d, out);
            }
        } else {
            out.writeBoolean(false);
            Single d = (Single)decision;
            Type.writeTo(d.type, out);
            out.writeOptionalString(d.label);
            out.writeOptionalString(d.getExplanation());
        }
    }

    public static Decision readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            Multi result = new Multi();
            int decisionCount = in.readVInt();
            for (int i = 0; i < decisionCount; ++i) {
                Decision s = Decision.readFrom(in);
                result.decisions.add(s);
            }
            return result;
        }
        Single result = new Single();
        result.type = Type.readFrom(in);
        result.label = in.readOptionalString();
        result.explanationString = in.readOptionalString();
        return result;
    }

    public abstract Type type();

    @Nullable
    public abstract String label();

    public abstract List<Decision> getDecisions();

    public static class Multi
    extends Decision {
        private final List<Decision> decisions = new ArrayList<Decision>();

        public Multi add(Decision decision) {
            this.decisions.add(decision);
            return this;
        }

        @Override
        public Type type() {
            Type ret = Type.YES;
            for (int i = 0; i < this.decisions.size(); ++i) {
                Type type = this.decisions.get(i).type();
                if (type == Type.NO) {
                    return type;
                }
                if (type != Type.THROTTLE) continue;
                ret = type;
            }
            return ret;
        }

        @Override
        @Nullable
        public String label() {
            return null;
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.unmodifiableList(this.decisions);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Multi m = (Multi)object;
            return this.decisions.equals(m.decisions);
        }

        public int hashCode() {
            return 31 * this.decisions.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Decision decision : this.decisions) {
                sb.append("[").append(decision.toString()).append("]");
            }
            return sb.toString();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("decisions");
            for (Decision d : this.decisions) {
                d.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }
    }

    public static class Single
    extends Decision {
        private Type type;
        private String label;
        private String explanation;
        private String explanationString;
        private Object[] explanationParams;

        public Single() {
        }

        public Single(Type type) {
            this(type, null, null, null);
        }

        public Single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
            this.type = type;
            this.label = label;
            this.explanation = explanation;
            this.explanationParams = explanationParams;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.singletonList(this);
        }

        @Nullable
        public String getExplanation() {
            if (this.explanationString == null && this.explanation != null) {
                this.explanationString = String.format(Locale.ROOT, this.explanation, this.explanationParams);
            }
            return this.explanationString;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Single s = (Single)object;
            return this.type == s.type && Objects.equals(this.label, s.label) && Objects.equals(this.getExplanation(), s.getExplanation());
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            String explanationStr = this.getExplanation();
            result = 31 * result + (explanationStr == null ? 0 : explanationStr.hashCode());
            return result;
        }

        public String toString() {
            if (this.explanationString != null || this.explanation != null) {
                return (Object)((Object)this.type) + "(" + this.getExplanation() + ")";
            }
            return (Object)((Object)this.type) + "()";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("decider", this.label);
            builder.field("decision", (Object)this.type);
            String explanation = this.getExplanation();
            builder.field("explanation", explanation != null ? explanation : "none");
            builder.endObject();
            return builder;
        }
    }

    public static enum Type {
        YES,
        NO,
        THROTTLE;


        public static Type resolve(String s) {
            return Type.valueOf(s.toUpperCase(Locale.ROOT));
        }

        public static Type readFrom(StreamInput in) throws IOException {
            int i = in.readVInt();
            switch (i) {
                case 0: {
                    return NO;
                }
                case 1: {
                    return YES;
                }
                case 2: {
                    return THROTTLE;
                }
            }
            throw new IllegalArgumentException("No Type for integer [" + i + "]");
        }

        public static void writeTo(Type type, StreamOutput out) throws IOException {
            switch (type) {
                case NO: {
                    out.writeVInt(0);
                    break;
                }
                case YES: {
                    out.writeVInt(1);
                    break;
                }
                case THROTTLE: {
                    out.writeVInt(2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Type [" + (Object)((Object)type) + "]");
                }
            }
        }
    }
}

