/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportAddressSerializers {
    private static final Map<Short, Writeable.Reader<TransportAddress>> ADDRESS_REGISTRY;

    private static void addAddressType(Map<Short, Writeable.Reader<TransportAddress>> registry, short uniqueAddressTypeId, Writeable.Reader<TransportAddress> address) {
        if (registry.containsKey(uniqueAddressTypeId)) {
            throw new IllegalStateException("Address [" + uniqueAddressTypeId + "] already bound");
        }
        registry.put(uniqueAddressTypeId, address);
    }

    public static TransportAddress addressFromStream(StreamInput input) throws IOException {
        short addressUniqueId = input.readShort();
        Writeable.Reader<TransportAddress> addressType = ADDRESS_REGISTRY.get(addressUniqueId);
        if (addressType == null) {
            throw new IOException("No transport address mapped to [" + addressUniqueId + "]");
        }
        return addressType.read(input);
    }

    public static void addressToStream(StreamOutput out, TransportAddress address) throws IOException {
        out.writeShort(address.uniqueAddressTypeId());
        address.writeTo(out);
    }

    static {
        HashMap<Short, Writeable.Reader<TransportAddress>> registry = new HashMap<Short, Writeable.Reader<TransportAddress>>();
        TransportAddressSerializers.addAddressType(registry, (short)1, InetSocketTransportAddress::new);
        TransportAddressSerializers.addAddressType(registry, (short)2, LocalTransportAddress::new);
        ADDRESS_REGISTRY = Collections.unmodifiableMap(registry);
    }
}

