/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class AnalysisService
extends AbstractIndexComponent
implements Closeable {
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, TokenizerFactory> tokenizers;
    private final Map<String, CharFilterFactory> charFilters;
    private final Map<String, TokenFilterFactory> tokenFilters;
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final NamedAnalyzer defaultSearchAnalyzer;
    private final NamedAnalyzer defaultSearchQuoteAnalyzer;

    public AnalysisService(IndexSettings indexSettings, Map<String, AnalyzerProvider<?>> analyzerProviders, Map<String, TokenizerFactory> tokenizerFactoryFactories, Map<String, CharFilterFactory> charFilterFactoryFactories, Map<String, TokenFilterFactory> tokenFilterFactoryFactories) {
        super(indexSettings);
        NamedAnalyzer defaultAnalyzer;
        this.tokenizers = Collections.unmodifiableMap(tokenizerFactoryFactories);
        this.charFilters = Collections.unmodifiableMap(charFilterFactoryFactories);
        this.tokenFilters = Collections.unmodifiableMap(tokenFilterFactoryFactories);
        analyzerProviders = new HashMap(analyzerProviders);
        HashMap<String, NamedAnalyzer> analyzerAliases = new HashMap<String, NamedAnalyzer>();
        HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
        for (Map.Entry<String, AnalyzerProvider<?>> entry : analyzerProviders.entrySet()) {
            this.processAnalyzerFactory(entry.getKey(), entry.getValue(), analyzerAliases, analyzers);
        }
        for (Map.Entry<String, AnalyzerProvider<Object>> entry : analyzerAliases.entrySet()) {
            String key = entry.getKey();
            if (analyzers.containsKey(key) && !("default".equals(key) || "default_search".equals(key) || "default_search_quoted".equals(key))) {
                throw new IllegalStateException("already registered analyzer with name: " + key);
            }
            NamedAnalyzer configured = (NamedAnalyzer)((Object)entry.getValue());
            analyzers.put(key, configured);
        }
        if (!analyzers.containsKey("default")) {
            this.processAnalyzerFactory("default", new StandardAnalyzerProvider(indexSettings, null, "default", Settings.Builder.EMPTY_SETTINGS), analyzerAliases, analyzers);
        }
        if (!analyzers.containsKey("default_search")) {
            analyzers.put("default_search", (NamedAnalyzer)((Object)analyzers.get("default")));
        }
        if (!analyzers.containsKey("default_search_quoted")) {
            analyzers.put("default_search_quoted", (NamedAnalyzer)((Object)analyzers.get("default_search")));
        }
        if ((defaultAnalyzer = (NamedAnalyzer)((Object)analyzers.get("default"))) == null) {
            throw new IllegalArgumentException("no default analyzer configured");
        }
        if (analyzers.containsKey("default_index")) {
            Version version = indexSettings.getIndexVersionCreated();
            if (version.onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("setting [index.analysis.analyzer.default_index] is not supported anymore, use [index.analysis.analyzer.default] instead for index [" + this.index().getName() + "]");
            }
            this.deprecationLogger.deprecated("setting [index.analysis.analyzer.default_index] is deprecated, use [index.analysis.analyzer.default] instead for index [{}]", this.index().getName());
        }
        this.defaultIndexAnalyzer = analyzers.containsKey("default_index") ? (NamedAnalyzer)((Object)analyzers.get("default_index")) : defaultAnalyzer;
        this.defaultSearchAnalyzer = analyzers.containsKey("default_search") ? (NamedAnalyzer)((Object)analyzers.get("default_search")) : defaultAnalyzer;
        this.defaultSearchQuoteAnalyzer = analyzers.containsKey("default_search_quote") ? (NamedAnalyzer)((Object)analyzers.get("default_search_quote")) : this.defaultSearchAnalyzer;
        for (Map.Entry analyzer : analyzers.entrySet()) {
            if (!((String)analyzer.getKey()).startsWith("_")) continue;
            throw new IllegalArgumentException("analyzer name must not start with '_'. got \"" + (String)analyzer.getKey() + "\"");
        }
        this.analyzers = Collections.unmodifiableMap(analyzers);
    }

    private void processAnalyzerFactory(String name, AnalyzerProvider<?> analyzerFactory, Map<String, NamedAnalyzer> analyzerAliases, Map<String, NamedAnalyzer> analyzers) {
        NamedAnalyzer analyzer;
        Object analyzerF;
        int overridePositionIncrementGap = 100;
        if (analyzerFactory instanceof CustomAnalyzerProvider) {
            ((CustomAnalyzerProvider)analyzerFactory).build(this);
            overridePositionIncrementGap = Integer.MIN_VALUE;
        }
        if ((analyzerF = analyzerFactory.get()) == null) {
            throw new IllegalArgumentException("analyzer [" + analyzerFactory.name() + "] created null analyzer");
        }
        if (analyzerF instanceof NamedAnalyzer) {
            analyzer = (NamedAnalyzer)((Object)analyzerF);
            if (overridePositionIncrementGap >= 0 && analyzer.getPositionIncrementGap(analyzer.name()) != overridePositionIncrementGap) {
                analyzer = new NamedAnalyzer(analyzer, overridePositionIncrementGap);
            }
        } else {
            analyzer = new NamedAnalyzer(name, analyzerFactory.scope(), (Analyzer)analyzerF, overridePositionIncrementGap);
        }
        if (analyzers.containsKey(name)) {
            throw new IllegalStateException("already registered analyzer with name: " + name);
        }
        analyzers.put(name, analyzer);
        String analyzerAliasKey = "index.analysis.analyzer." + analyzerFactory.name() + ".alias";
        if (this.indexSettings.getSettings().get(analyzerAliasKey) != null) {
            if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_beta1)) {
                throw new IllegalArgumentException("setting [" + analyzerAliasKey + "] is not supported");
            }
            this.deprecationLogger.deprecated("setting [{}] is only allowed on index [{}] because it was created before 5.x; analyzer aliases can no longer be created on new indices.", analyzerAliasKey, this.index().getName());
            HashSet<String> aliases = Sets.newHashSet(this.indexSettings.getSettings().getAsArray(analyzerAliasKey));
            for (String alias : aliases) {
                if (analyzerAliases.putIfAbsent(alias, analyzer) == null) continue;
                throw new IllegalStateException("alias [" + alias + "] is already used by [" + analyzerAliases.get(alias).name() + "]");
            }
        }
    }

    @Override
    public void close() {
        for (NamedAnalyzer analyzer : this.analyzers.values()) {
            if (analyzer.scope() != AnalyzerScope.INDEX) continue;
            try {
                analyzer.close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                this.logger.debug("failed to close analyzer {}", (Object)analyzer);
            }
        }
    }

    public NamedAnalyzer analyzer(String name) {
        return this.analyzers.get(name);
    }

    public NamedAnalyzer defaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    public NamedAnalyzer defaultSearchAnalyzer() {
        return this.defaultSearchAnalyzer;
    }

    public NamedAnalyzer defaultSearchQuoteAnalyzer() {
        return this.defaultSearchQuoteAnalyzer;
    }

    public TokenizerFactory tokenizer(String name) {
        return this.tokenizers.get(name);
    }

    public CharFilterFactory charFilter(String name) {
        return this.charFilters.get(name);
    }

    public TokenFilterFactory tokenFilter(String name) {
        return this.tokenFilters.get(name);
    }
}

