/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.interop.java.NewNodeSubNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

abstract class NewNodeSub
extends JavaObjectMessageResolution.NewNode {
    NewNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    protected Object accessWithTarget(JavaObject object, Object[] args) {
        return this.access(object, args);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new NEWRootNode(language);
    }

    private static final class NEWRootNode
    extends RootNode {
        @Node.Child
        private NewNodeSub node = NewNodeSubNodeGen.create();

        protected NEWRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            try {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                List<Object> arguments = ForeignAccess.getArguments(frame);
                Object[] args = new Object[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    args[i] = arguments.get(i);
                }
                return this.node.executeWithTarget(frame, receiver, args);
            }
            catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
            }
        }
    }
}

