/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.renderer.ModelPrinter;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.layouting.renderer.process.InfiniteMinorAxisLayoutStep;
import org.jfree.layouting.renderer.process.TextAlignmentProcessor;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.util.LongList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public abstract class AbstractAlignmentProcessor
implements TextAlignmentProcessor {
    private static final int START = 0;
    private static final int CONTENT = 1;
    private static final int END = 2;
    private long startOfLine;
    private long endOfLine;
    private long[] pagebreaks;
    private PageGrid pageGrid;
    private InlineSequenceElement[] sequenceElements;
    private int sequenceFill;
    private int breakableIndex;
    private int skipIndex;
    private long[] elementPositions;
    private long[] elementDimensions;

    public long getStartOfLine() {
        return this.startOfLine;
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    protected InlineSequenceElement[] getSequenceElements() {
        return this.sequenceElements;
    }

    public long[] getElementPositions() {
        return this.elementPositions;
    }

    public long[] getElementDimensions() {
        return this.elementDimensions;
    }

    public long getEndOfLine() {
        return this.endOfLine;
    }

    protected long getPageBreak(int n) {
        return this.pagebreaks[n];
    }

    public int getBreakableIndex() {
        return this.breakableIndex;
    }

    public void setBreakableIndex(int n) {
        this.breakableIndex = n;
    }

    public int getSkipIndex() {
        return this.skipIndex;
    }

    public void setSkipIndex(int n) {
        this.skipIndex = n;
    }

    public int iterate(InlineSequenceElement[] inlineSequenceElementArray, int n) {
        this.breakableIndex = -1;
        this.skipIndex = -1;
        if (n == 0) {
            return 0;
        }
        int n2 = this.classifyInput(inlineSequenceElementArray[0]);
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            InlineSequenceElement inlineSequenceElement = inlineSequenceElementArray[i];
            int n4 = this.classifyInput(inlineSequenceElement);
            if (n4 == 2) {
                n2 = n4;
                continue;
            }
            if (n2 == 0) {
                n2 = n4;
                continue;
            }
            int n5 = this.handleElement(n3, i - n3);
            if (n5 <= n3) {
                return n3;
            }
            n3 = i;
            n2 = n4;
        }
        return this.handleElement(n3, n - n3);
    }

    public void initialize(InlineSequenceElement[] inlineSequenceElementArray, long l, long l2, PageGrid pageGrid) {
        if (l2 < l) {
            throw new IllegalArgumentException("Start is <= end; which is stupid!: " + l2 + ' ' + l);
        }
        this.sequenceElements = inlineSequenceElementArray;
        this.sequenceFill = inlineSequenceElementArray.length;
        this.startOfLine = l;
        this.endOfLine = l2;
        this.pageGrid = pageGrid;
        this.elementPositions = new long[this.sequenceElements.length];
        this.elementDimensions = new long[this.sequenceElements.length];
        this.updateBreaks();
    }

    private void updateBreaks() {
        int n = this.pageGrid.getColumnCount();
        LongList longList = new LongList(n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            if (l < this.startOfLine) continue;
            PhysicalPageBox physicalPageBox = this.pageGrid.getPage(0, i);
            if ((l += physicalPageBox.getImageableWidth()) >= this.endOfLine) break;
            longList.add(l);
        }
        longList.add(this.endOfLine);
        this.pagebreaks = longList.toArray();
    }

    public boolean hasNext() {
        return this.sequenceFill > 0;
    }

    public RenderNode next() {
        int n;
        RenderNode renderNode;
        int n2;
        Arrays.fill(this.elementDimensions, 0L);
        Arrays.fill(this.elementPositions, 0L);
        int n3 = this.iterate(this.sequenceElements, this.sequenceFill);
        if (n3 == 0) {
            if (this.getBreakableIndex() >= 0) {
                // empty if block
            }
            n3 = this.getSkipIndex() >= 0 ? this.getSkipIndex() : this.sequenceFill;
        }
        ArrayList<RenderNode> arrayList = new ArrayList<RenderNode>();
        FastStack fastStack = new FastStack();
        RenderBox renderBox = null;
        RenderBox renderBox2 = null;
        for (n2 = 0; n2 < n3; ++n2) {
            RenderNode renderNode2;
            InlineSequenceElement inlineSequenceElement = this.sequenceElements[n2];
            if (inlineSequenceElement instanceof EndSequenceElement) {
                fastStack.pop();
                long l = this.elementPositions[n2] + this.elementDimensions[n2];
                renderBox2.setWidth(l - renderBox2.getX());
                if (fastStack.isEmpty()) {
                    renderBox2 = null;
                    continue;
                }
                renderNode2 = renderBox2;
                renderBox2 = (RenderBox)fastStack.peek();
                renderBox2.addGeneratedChild(renderNode2);
                continue;
            }
            if (inlineSequenceElement instanceof StartSequenceElement) {
                RenderNode renderNode3 = inlineSequenceElement.getNode();
                renderBox2 = (RenderBox)renderNode3.derive(false);
                renderBox2.setX(this.elementPositions[n2]);
                fastStack.push((Object)renderBox2);
                if (renderBox != null) continue;
                renderBox = renderBox2;
                continue;
            }
            if (renderBox2 == null) {
                throw new IllegalStateException("Invalid sequence: Cannot have elements before we open the box context.");
            }
            RenderNode renderNode4 = inlineSequenceElement.getNode().derive(true);
            renderNode4.setX(this.elementPositions[n2]);
            renderNode4.setWidth(this.elementDimensions[n2]);
            if (renderBox2.isPreserveSpace()) {
                renderBox2.addGeneratedChild(renderNode4);
                continue;
            }
            if (renderNode4.isIgnorableForRendering()) {
                arrayList.add(renderNode4);
                continue;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                renderNode2 = (RenderNode)arrayList.get(i);
                renderBox2.addGeneratedChild(renderNode2);
            }
            arrayList.clear();
            renderBox2.addGeneratedChild(renderNode4);
        }
        while (n3 < this.sequenceFill && (renderNode = this.sequenceElements[n3].getNode()).isDiscardable()) {
            ++n3;
        }
        n2 = fastStack.size();
        for (n = 0; n < n2; ++n) {
            RenderBox renderBox3 = (RenderBox)fastStack.get(n);
            renderBox3.setWidth(this.getEndOfLine() - renderBox2.getX());
            InlineRenderBox inlineRenderBox = (InlineRenderBox)renderBox3.split(0);
            this.sequenceElements[n] = new StartSequenceElement(inlineRenderBox);
        }
        n = this.sequenceFill - n3;
        System.arraycopy(this.sequenceElements, n3, this.sequenceElements, n2, n);
        this.sequenceFill = n2 + n;
        Arrays.fill(this.sequenceElements, this.sequenceFill, this.sequenceElements.length, null);
        return renderBox;
    }

    protected int handleElement(int n, int n2) {
        int n3 = n + n2;
        InlineSequenceElement[] inlineSequenceElementArray = this.getSequenceElements();
        int n4 = n;
        long l = 0L;
        for (int i = 0; i < n3; ++i) {
            InlineSequenceElement inlineSequenceElement = inlineSequenceElementArray[i];
            l += inlineSequenceElement.getMaximumWidth();
            if (inlineSequenceElement instanceof StartSequenceElement || inlineSequenceElement instanceof EndSequenceElement) continue;
            n4 = i;
        }
        long l2 = this.getPageBreak(0);
        if (l > l2) {
            return n;
        }
        return this.handleLayout(n, n2, n4, l);
    }

    protected abstract int handleLayout(int var1, int var2, int var3, long var4);

    private int classifyInput(InlineSequenceElement inlineSequenceElement) {
        if (inlineSequenceElement instanceof StartSequenceElement) {
            return 0;
        }
        if (inlineSequenceElement instanceof EndSequenceElement) {
            return 2;
        }
        return 1;
    }

    protected void computeInlineBlock(RenderBox renderBox, long l, long l2) {
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        renderBox.setX(l + computedLayoutProperties.getMarginLeft());
        long l3 = l2 - computedLayoutProperties.getMarginLeft() - computedLayoutProperties.getMarginRight();
        if (l3 == 0L) {
            ModelPrinter.printParents(renderBox);
            throw new IllegalStateException("A box without any width? " + Integer.toHexString(System.identityHashCode(renderBox)) + ' ' + renderBox.getClass());
        }
        renderBox.setWidth(l3);
        long l4 = computedLayoutProperties.getPaddingLeft() + computedLayoutProperties.getBorderLeft();
        long l5 = computedLayoutProperties.getPaddingRight() + computedLayoutProperties.getBorderRight();
        renderBox.setContentAreaX1(renderBox.getX() + l4);
        renderBox.setContentAreaX2(renderBox.getX() + renderBox.getWidth() - l5);
        InfiniteMinorAxisLayoutStep infiniteMinorAxisLayoutStep = new InfiniteMinorAxisLayoutStep();
        infiniteMinorAxisLayoutStep.continueComputation(this.getPageGrid(), renderBox);
    }
}

