/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPDuration;
import java.awt.Color;

public class ColorScheme
implements Cloneable {
    private Color uniqueColor;
    private Color[] colors = new Color[]{new Color(0, 200, 200), new Color(0, 0, 255), new Color(0, 0, 0), new Color(227, 0, 0), new Color(0, 153, 0), new Color(153, 204, 0), new Color(255, 200, 0), new Color(255, 255, 0)};

    public ColorScheme() {
        this.uniqueColor = null;
    }

    public ColorScheme(Color c) {
        if (c != null) {
            this.uniqueColor = c;
        }
    }

    public void gradientLighterFrom(Color base, int delta) {
        if (base != null) {
            Color c = base;
            int R = c.getRed();
            int G = c.getGreen();
            int B = c.getBlue();
            int i = 0;
            while (i < this.colors.length) {
                this.colors[i] = c;
                int f = i * delta;
                c = R + f > 255 || G + f > 255 || B + f > 255 ? Color.WHITE : new Color(R + f, G + f, B + f);
                ++i;
            }
        }
    }

    public void gradientDarkerUntil(Color base, int delta) {
        if (base != null) {
            Color c = base;
            int R = c.getRed();
            int G = c.getGreen();
            int B = c.getBlue();
            int i = 7;
            while (i >= 0) {
                this.colors[i] = c;
                int f = (8 - i) * delta;
                c = R + f > 255 || G + f > 255 || B + f > 255 ? Color.WHITE : new Color(R + f, G + f, B + f);
                --i;
            }
        }
    }

    public void setColors(Color[] array) {
        if (array != null && array.length == this.colors.length) {
            this.colors = array;
            this.uniqueColor = null;
        }
    }

    public boolean isUniqueColor() {
        return this.uniqueColor != null;
    }

    public boolean setColor(Color color, int pos) {
        boolean success = false;
        if (color != null && pos >= 0 && pos < this.colors.length) {
            if (this.uniqueColor != null) {
                int i = 0;
                while (i < this.colors.length) {
                    this.colors[pos] = i != pos ? this.uniqueColor : color;
                    ++i;
                }
                this.uniqueColor = null;
            } else {
                this.colors[pos] = color;
            }
            success = true;
        }
        return success;
    }

    public void setColor(Color color) {
        this.uniqueColor = color;
    }

    public Color getColor() {
        return this.uniqueColor;
    }

    public Color getColor(int pos) {
        Color resp = null;
        if (pos >= 0 && pos < this.colors.length) {
            resp = this.uniqueColor != null ? this.uniqueColor : this.colors[pos];
        }
        return resp;
    }

    public Color getColor(GPDuration duration) {
        Color resp = null;
        if (duration != null) {
            if (this.uniqueColor != null) {
                resp = this.uniqueColor;
            } else {
                int pos = duration.getIndex();
                if (pos >= 0 && pos < this.colors.length) {
                    resp = this.colors[pos];
                }
            }
        }
        return resp;
    }

    public boolean equals(Object obj) {
        boolean resp = false;
        if (obj != null && obj.getClass().isInstance(this)) {
            ColorScheme other = (ColorScheme)obj;
            if (this.uniqueColor != null) {
                resp = this.uniqueColor.equals(other.uniqueColor);
            } else if (other.uniqueColor == null) {
                int i = 0;
                while ((resp = this.colors[i].equals(other.colors[i])) && ++i < this.colors.length) {
                }
            }
        }
        return resp;
    }

    protected Object clone() {
        ColorScheme retValue = new ColorScheme();
        if (this.isUniqueColor()) {
            retValue.uniqueColor = this.uniqueColor;
        } else {
            retValue.colors = (Color[])this.colors.clone();
        }
        return retValue;
    }
}

