/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.TextTagParser;

public final class OsmUtils {
    private static final Set<String> TRUE_VALUES = new HashSet<String>(Arrays.asList("true", "yes", "1", "on"));
    private static final Set<String> FALSE_VALUES = new HashSet<String>(Arrays.asList("false", "no", "0", "off"));
    private static final Set<String> REVERSE_VALUES = new HashSet<String>(Arrays.asList("reverse", "-1"));
    public static final String trueval = "yes";
    public static final String falseval = "no";
    public static final String reverseval = "-1";

    private OsmUtils() {
    }

    public static Boolean getOsmBoolean(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (TRUE_VALUES.contains(string2)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getNamedOsmBoolean(String string) {
        Boolean bl = OsmUtils.getOsmBoolean(string);
        return bl == null ? string : (bl != false ? trueval : falseval);
    }

    public static boolean isReversed(String string) {
        return REVERSE_VALUES.contains(string);
    }

    public static boolean isTrue(String string) {
        return TRUE_VALUES.contains(string);
    }

    public static boolean isFalse(String string) {
        return FALSE_VALUES.contains(string);
    }

    public static OsmPrimitive createPrimitive(String string) {
        Node node;
        CheckParameterUtil.ensureParameterNotNull(string, "assertion");
        String[] stringArray = string.split("\\s+", 2);
        OsmPrimitive osmPrimitive = "n".equals(stringArray[0]) || "node".equals(stringArray[0]) ? new Node(LatLon.ZERO) : ("w".equals(stringArray[0]) || "way".equals(stringArray[0]) || "area".equals(stringArray[0]) ? new Way() : (node = "r".equals(stringArray[0]) || "relation".equals(stringArray[0]) ? new Relation() : null));
        if (node == null) {
            throw new IllegalArgumentException("Expecting n/node/w/way/r/relation/area, but got '" + stringArray[0] + '\'');
        }
        if (stringArray.length > 1) {
            for (Map.Entry<String, String> entry : TextTagParser.readTagsFromText(stringArray[1]).entrySet()) {
                node.put(entry.getKey(), entry.getValue());
            }
        }
        return node;
    }
}

