/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class Relation
extends OsmPrimitive
implements IRelation {
    private RelationMember[] members = new RelationMember[0];
    private BBox bbox;

    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(List<RelationMember> list) {
        boolean bl = this.writeLock();
        try {
            for (RelationMember relationMember : this.members) {
                relationMember.getMember().removeReferrer(this);
                relationMember.getMember().clearCachedStyle();
            }
            this.members = list != null ? list.toArray(new RelationMember[list.size()]) : new RelationMember[0];
            for (RelationMember relationMember : this.members) {
                relationMember.getMember().addReferrer(this);
                relationMember.getMember().clearCachedStyle();
            }
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public int getMembersCount() {
        return this.members.length;
    }

    public RelationMember getMember(int n) {
        return this.members[n];
    }

    public void addMember(RelationMember relationMember) {
        boolean bl = this.writeLock();
        try {
            this.members = Utils.addInArrayCopy(this.members, relationMember);
            relationMember.getMember().addReferrer(this);
            relationMember.getMember().clearCachedStyle();
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(int n, RelationMember relationMember) {
        boolean bl = this.writeLock();
        try {
            RelationMember[] relationMemberArray = new RelationMember[this.members.length + 1];
            System.arraycopy(this.members, 0, relationMemberArray, 0, n);
            System.arraycopy(this.members, n, relationMemberArray, n + 1, this.members.length - n);
            relationMemberArray[n] = relationMember;
            this.members = relationMemberArray;
            relationMember.getMember().addReferrer(this);
            relationMember.getMember().clearCachedStyle();
            this.fireMembersChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember setMember(int n, RelationMember relationMember) {
        boolean bl = this.writeLock();
        try {
            RelationMember relationMember2 = this.members[n];
            this.members[n] = relationMember;
            if (relationMember2.getMember() != relationMember.getMember()) {
                relationMember.getMember().addReferrer(this);
                relationMember.getMember().clearCachedStyle();
                relationMember2.getMember().removeReferrer(this);
                relationMember2.getMember().clearCachedStyle();
                this.fireMembersChanged();
            }
            RelationMember relationMember3 = relationMember2;
            return relationMember3;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationMember removeMember(int n) {
        boolean bl = this.writeLock();
        try {
            List<RelationMember> list = this.getMembers();
            RelationMember relationMember = list.remove(n);
            this.setMembers(list);
            RelationMember relationMember2 = relationMember;
            return relationMember2;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public long getMemberId(int n) {
        return this.members[n].getUniqueId();
    }

    @Override
    public String getRole(int n) {
        return this.members[n].getRole();
    }

    @Override
    public OsmPrimitiveType getMemberType(int n) {
        return this.members[n].getType();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    protected Relation(long l, boolean bl) {
        super(l, bl);
    }

    public Relation() {
        super(0L, false);
    }

    public Relation(Relation relation, boolean bl) {
        super(relation.getUniqueId(), true);
        this.cloneFrom(relation);
        if (bl) {
            this.clearOsmMetadata();
        }
    }

    public Relation(Relation relation) {
        this(relation, false);
    }

    public Relation(long l) {
        super(l, false);
    }

    public Relation(long l, int n) {
        super(l, n, false);
    }

    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            this.setMembers(((Relation)osmPrimitive).getMembers());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            RelationData relationData = (RelationData)primitiveData;
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMemberData relationMemberData : relationData.getMembers()) {
                OsmPrimitive osmPrimitive = this.getDataSet().getPrimitiveById(relationMemberData);
                if (osmPrimitive == null) {
                    throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
                }
                arrayList.add(new RelationMember(relationMemberData.getRole(), osmPrimitive));
            }
            this.setMembers(arrayList);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public RelationData save() {
        RelationData relationData = new RelationData();
        this.saveCommonAttributes(relationData);
        for (RelationMember relationMember : this.getMembers()) {
            relationData.getMembers().add(new RelationMemberData(relationMember.getRole(), relationMember.getMember()));
        }
        return relationData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("{Relation id=").append(this.getUniqueId()).append(" version=").append(this.getVersion()).append(' ').append(this.getFlagsAsString()).append(" [");
        for (RelationMember relationMember : this.getMembers()) {
            stringBuilder.append((Object)OsmPrimitiveType.from(relationMember.getMember())).append(' ').append(relationMember.getMember().getUniqueId()).append(", ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length()).append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive, boolean bl) {
        if (!(osmPrimitive instanceof Relation)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive, bl)) {
            return false;
        }
        Relation relation = (Relation)osmPrimitive;
        return Arrays.equals(this.members, relation.members);
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation ? Long.compare(this.getUniqueId(), osmPrimitive.getUniqueId()) : -1;
    }

    public RelationMember firstMember() {
        return this.isIncomplete() || this.members.length == 0 ? null : this.members[0];
    }

    public RelationMember lastMember() {
        return this.isIncomplete() || this.members.length == 0 ? null : this.members[this.members.length - 1];
    }

    public void removeMembersFor(OsmPrimitive osmPrimitive) {
        this.removeMembersFor(Collections.singleton(osmPrimitive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            for (RelationMember relationMember : this.members) {
                if (bl) {
                    relationMember.getMember().removeReferrer(this);
                    continue;
                }
                relationMember.getMember().addReferrer(this);
            }
            super.setDeleted(bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    public Collection<RelationMember> getMembersFor(Collection<? extends OsmPrimitive> collection) {
        return SubclassFilteredCollection.filter(this.getMembers(), relationMember -> collection.contains(relationMember.getMember()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMembersFor(Collection<? extends OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            List<RelationMember> list = this.getMembers();
            list.removeAll(this.getMembersFor(collection));
            this.setMembers(list);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        RelationMember[] relationMemberArray;
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : relationMemberArray = this.members) {
            if (relationMember.getMember() == null) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    public <T extends OsmPrimitive> Collection<T> getMemberPrimitives(Class<T> clazz) {
        return Utils.filteredCollection(this.getMemberPrimitives(), clazz);
    }

    public List<OsmPrimitive> getMemberPrimitivesList() {
        return Utils.transform(this.getMembers(), RelationMember::getMember);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.isMultipolygon() && !this.isBoundary() ? OsmPrimitiveType.MULTIPOLYGON : OsmPrimitiveType.RELATION;
    }

    public boolean isBoundary() {
        return "boundary".equals(this.get("type"));
    }

    @Override
    public boolean isMultipolygon() {
        return "multipolygon".equals(this.get("type")) || this.isBoundary();
    }

    @Override
    public BBox getBBox() {
        RelationMember[] relationMemberArray = this.members;
        if (relationMemberArray.length == 0) {
            return new BBox(0.0, 0.0, 0.0, 0.0);
        }
        if (this.getDataSet() == null) {
            return this.calculateBBox(new HashSet<PrimitiveId>());
        }
        if (this.bbox == null) {
            this.bbox = this.calculateBBox(new HashSet<PrimitiveId>());
        }
        if (this.bbox == null) {
            return new BBox(0.0, 0.0, 0.0, 0.0);
        }
        return new BBox(this.bbox);
    }

    private BBox calculateBBox(Set<PrimitiveId> set) {
        if (set.contains(this)) {
            return null;
        }
        set.add(this);
        RelationMember[] relationMemberArray = this.members;
        if (relationMemberArray.length == 0) {
            return null;
        }
        BBox bBox = null;
        for (RelationMember relationMember : relationMemberArray) {
            BBox bBox2;
            BBox bBox3 = bBox2 = relationMember.isRelation() ? relationMember.getRelation().calculateBBox(set) : relationMember.getMember().getBBox();
            if (bBox2 == null) continue;
            if (bBox == null) {
                bBox = bBox2;
                continue;
            }
            bBox.add(bBox2);
        }
        return bBox;
    }

    @Override
    public void updatePosition() {
        this.bbox = this.calculateBBox(new HashSet<PrimitiveId>());
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkMembers();
        this.bbox = null;
    }

    private void checkMembers() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            RelationMember[] relationMemberArray;
            for (RelationMember relationMember : relationMemberArray = this.members) {
                if (relationMember.getMember().getDataSet() == dataSet) continue;
                throw new DataIntegrityProblemException(String.format("Relation member must be part of the same dataset as relation(%s, %s)", this.getPrimitiveId(), relationMember.getMember().getPrimitiveId()));
            }
            if (Main.pref.getBoolean("debug.checkDeleteReferenced", true)) {
                for (RelationMember relationMember : relationMemberArray) {
                    if (!relationMember.getMember().isDeleted()) continue;
                    throw new DataIntegrityProblemException("Deleted member referenced: " + this.toString());
                }
            }
        }
    }

    private void fireMembersChanged() {
        this.checkMembers();
        if (this.getDataSet() != null) {
            this.getDataSet().fireRelationMembersChanged(this);
        }
    }

    public boolean hasIncompleteMembers() {
        RelationMember[] relationMemberArray;
        for (RelationMember relationMember : relationMemberArray = this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public Collection<OsmPrimitive> getIncompleteMembers() {
        RelationMember[] relationMemberArray;
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (RelationMember relationMember : relationMemberArray = this.members) {
            if (!relationMember.getMember().isIncomplete()) continue;
            hashSet.add(relationMember.getMember());
        }
        return hashSet;
    }

    @Override
    protected void keysChangedImpl(Map<String, String> map) {
        super.keysChangedImpl(map);
        for (OsmPrimitive osmPrimitive : this.getMemberPrimitives()) {
            osmPrimitive.clearCachedStyle();
        }
    }

    @Override
    public boolean concernsArea() {
        return this.isMultipolygon() && this.hasAreaTags();
    }

    @Override
    public boolean isOutsideDownloadArea() {
        return false;
    }

    public Set<String> getMemberRoles() {
        HashSet<String> hashSet = new HashSet<String>();
        for (RelationMember relationMember : this.members) {
            String string = relationMember.getRole();
            if (string.isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }
}

