/*!
 * Tobi - Cookie
 * Copyright(c) 2010 LearnBoost <dev@learnboost.com>
 * MIT Licensed
 */

/**
 * Module dependencies.
 */

var url = require('url');

/**
 * Initialize a new `Cookie` with the given cookie `str` and `req`.
 *
 * @param {String} str
 * @param {IncomingRequest} req
 * @api private
 */

var Cookie = exports = module.exports = function Cookie(str, req) {
  this.str = str;

  // Map the key/val pairs
  str.split(/ *; */).reduce(function(obj, pair){
   var p = pair.indexOf('=');
   var key = p > 0 ? pair.substring(0, p).trim() : pair.trim();
   var lowerCasedKey = key.toLowerCase();
   var value = p > 0 ? pair.substring(p + 1).trim() : true;

   if (!obj.name) {
    // First key is the name
    obj.name = key;
    obj.value = value;
   }
   else if (lowerCasedKey === 'httponly') {
    obj.httpOnly = value;
   }
   else {
    obj[lowerCasedKey] = value;
   }
   return obj;
  }, this);

  // Expires
  this.expires = this.expires
    ? new Date(this.expires)
    : Infinity;

  // Default or trim path
  this.path = this.path
    ? this.path.trim(): req 
    ? url.parse(req.url).pathname: '/';
};

/**
 * Return the original cookie string.
 *
 * @return {String}
 * @api public
 */

Cookie.prototype.toString = function(){
  return this.str;
};

module.exports.Jar = require('./jar')