/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class DeleteResponse
extends DocWriteResponse {
    public DeleteResponse() {
    }

    public DeleteResponse(ShardId shardId, String type, String id, long version, boolean found) {
        super(shardId, type, id, version, found ? DocWriteResponse.Result.DELETED : DocWriteResponse.Result.NOT_FOUND);
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.DELETED ? super.status() : RestStatus.NOT_FOUND;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("found", this.result == DocWriteResponse.Result.DELETED);
        super.toXContent(builder, params);
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }
}

