/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class ReplicationResponse
extends ActionResponse {
    public static final ShardInfo.Failure[] EMPTY = new ShardInfo.Failure[0];
    private ShardInfo shardInfo;

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardInfo = ShardInfo.readShardInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardInfo.writeTo(out);
    }

    public ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(ShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public static class ShardInfo
    implements Streamable,
    ToXContent {
        private int total;
        private int successful;
        private Failure[] failures = EMPTY;

        public ShardInfo() {
        }

        public ShardInfo(int total, int successful, Failure ... failures) {
            assert (total >= 0 && successful >= 0);
            this.total = total;
            this.successful = successful;
            this.failures = failures;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public int getFailed() {
            return this.failures.length;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        public RestStatus status() {
            RestStatus status = RestStatus.OK;
            for (Failure failure : this.failures) {
                if (!failure.primary() || failure.status().getStatus() <= status.getStatus()) continue;
                status = failure.status();
            }
            return status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            int size = in.readVInt();
            this.failures = new Failure[size];
            for (int i = 0; i < size; ++i) {
                Failure failure = new Failure();
                failure.readFrom(in);
                this.failures[i] = failure;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.failures.length);
            for (Failure failure : this.failures) {
                failure.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("_shards");
            builder.field("total", this.total);
            builder.field("successful", this.successful);
            builder.field("failed", this.getFailed());
            if (this.failures.length > 0) {
                builder.startArray("failures");
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString(this);
        }

        public static ShardInfo readShardInfo(StreamInput in) throws IOException {
            ShardInfo shardInfo = new ShardInfo();
            shardInfo.readFrom(in);
            return shardInfo;
        }

        private static class Fields {
            private static final String _SHARDS = "_shards";
            private static final String TOTAL = "total";
            private static final String SUCCESSFUL = "successful";
            private static final String FAILED = "failed";
            private static final String FAILURES = "failures";

            private Fields() {
            }
        }

        public static class Failure
        implements ShardOperationFailedException,
        ToXContent {
            private ShardId shardId;
            private String nodeId;
            private Exception cause;
            private RestStatus status;
            private boolean primary;

            public Failure(ShardId shardId, @Nullable String nodeId, Exception cause, RestStatus status, boolean primary) {
                this.shardId = shardId;
                this.nodeId = nodeId;
                this.cause = cause;
                this.status = status;
                this.primary = primary;
            }

            Failure() {
            }

            @Override
            public String index() {
                return this.shardId.getIndexName();
            }

            @Override
            public int shardId() {
                return this.shardId.id();
            }

            public ShardId fullShardId() {
                return this.shardId;
            }

            @Nullable
            public String nodeId() {
                return this.nodeId;
            }

            @Override
            public String reason() {
                return ExceptionsHelper.detailedMessage(this.cause);
            }

            @Override
            public RestStatus status() {
                return this.status;
            }

            @Override
            public Throwable getCause() {
                return this.cause;
            }

            public boolean primary() {
                return this.primary;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.shardId = ShardId.readShardId(in);
                this.nodeId = in.readOptionalString();
                this.cause = in.readException();
                this.status = RestStatus.readFrom(in);
                this.primary = in.readBoolean();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.shardId.writeTo(out);
                out.writeOptionalString(this.nodeId);
                out.writeException(this.cause);
                RestStatus.writeTo(out, this.status);
                out.writeBoolean(this.primary);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("_index", this.shardId.getIndexName());
                builder.field("_shard", this.shardId.id());
                builder.field("_node", this.nodeId);
                builder.field("reason");
                builder.startObject();
                ElasticsearchException.toXContent(builder, params, this.cause);
                builder.endObject();
                builder.field("status", (Object)this.status);
                builder.field("primary", this.primary);
                builder.endObject();
                return builder;
            }

            private static class Fields {
                private static final String _INDEX = "_index";
                private static final String _SHARD = "_shard";
                private static final String _NODE = "_node";
                private static final String REASON = "reason";
                private static final String STATUS = "status";
                private static final String PRIMARY = "primary";

                private Fields() {
                }
            }
        }
    }
}

