/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.cluster.routing.allocation.IndexMetaDataUpdater;
import org.elasticsearch.cluster.routing.allocation.RoutingNodesChangedObserver;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.shard.ShardId;

public class RoutingAllocation {
    private final AllocationDeciders deciders;
    private final RoutingNodes routingNodes;
    private final MetaData metaData;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final ImmutableOpenMap<String, ClusterState.Custom> customs;
    private final AllocationExplanation explanation = new AllocationExplanation();
    private final ClusterInfo clusterInfo;
    private Map<ShardId, Set<String>> ignoredShardToNodes = null;
    private boolean ignoreDisable = false;
    private final boolean retryFailed;
    private boolean debugDecision = false;
    private boolean hasPendingAsyncFetch = false;
    private final long currentNanoTime;
    private final IndexMetaDataUpdater indexMetaDataUpdater = new IndexMetaDataUpdater();
    private final RoutingNodesChangedObserver nodesChangedObserver = new RoutingNodesChangedObserver();
    private final RoutingChangesObserver routingChangesObserver = new RoutingChangesObserver.DelegatingRoutingChangesObserver(this.nodesChangedObserver, this.indexMetaDataUpdater);

    public RoutingAllocation(AllocationDeciders deciders, RoutingNodes routingNodes, ClusterState clusterState, ClusterInfo clusterInfo, long currentNanoTime, boolean retryFailed) {
        this.deciders = deciders;
        this.routingNodes = routingNodes;
        this.metaData = clusterState.metaData();
        this.routingTable = clusterState.routingTable();
        this.nodes = clusterState.nodes();
        this.customs = clusterState.customs();
        this.clusterInfo = clusterInfo;
        this.currentNanoTime = currentNanoTime;
        this.retryFailed = retryFailed;
    }

    public long getCurrentNanoTime() {
        return this.currentNanoTime;
    }

    public AllocationDeciders deciders() {
        return this.deciders;
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingNodes routingNodes() {
        return this.routingNodes;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public <T extends ClusterState.Custom> T custom(String key) {
        return (T)this.customs.get(key);
    }

    public AllocationExplanation explanation() {
        return this.explanation;
    }

    public void ignoreDisable(boolean ignoreDisable) {
        this.ignoreDisable = ignoreDisable;
    }

    public boolean ignoreDisable() {
        return this.ignoreDisable;
    }

    public void debugDecision(boolean debug) {
        this.debugDecision = debug;
    }

    public boolean debugDecision() {
        return this.debugDecision;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        Set<String> nodes;
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, Set<String>>();
        }
        if ((nodes = this.ignoredShardToNodes.get(shardId)) == null) {
            nodes = new HashSet<String>();
            this.ignoredShardToNodes.put(shardId, nodes);
        }
        nodes.add(nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            return false;
        }
        Set<String> nodes = this.ignoredShardToNodes.get(shardId);
        return nodes != null && nodes.contains(nodeId);
    }

    public Set<String> getIgnoreNodes(ShardId shardId) {
        if (this.ignoredShardToNodes == null) {
            return Collections.emptySet();
        }
        Set<String> ignore = this.ignoredShardToNodes.get(shardId);
        if (ignore == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(ignore));
    }

    public RoutingChangesObserver changes() {
        return this.routingChangesObserver;
    }

    public MetaData updateMetaDataWithRoutingChanges(RoutingTable newRoutingTable) {
        return this.indexMetaDataUpdater.applyChanges(this.metaData, newRoutingTable);
    }

    public boolean routingNodesChanged() {
        return this.nodesChangedObserver.isChanged();
    }

    public Decision decision(Decision decision, String deciderLabel, String reason, Object ... params) {
        if (this.debugDecision()) {
            return Decision.single(decision.type(), deciderLabel, reason, params);
        }
        return decision;
    }

    public boolean hasPendingAsyncFetch() {
        return this.hasPendingAsyncFetch;
    }

    public void setHasPendingAsyncFetch() {
        this.hasPendingAsyncFetch = true;
    }

    public boolean isRetryFailed() {
        return this.retryFailed;
    }
}

