/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;

public interface ScriptDocValues<T>
extends List<T> {
    public void setNextDocId(int var1);

    public List<T> getValues();

    public static final class Booleans
    extends AbstractList<Boolean>
    implements ScriptDocValues<Boolean> {
        private final SortedNumericDocValues values;

        public Booleans(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        @Override
        public List<Boolean> getValues() {
            return this;
        }

        public boolean getValue() {
            return this.values.count() != 0 && this.values.valueAt(0) == 1L;
        }

        @Override
        public Boolean get(int index) {
            return this.values.valueAt(index) == 1L;
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static class GeoPoints
    extends AbstractList<GeoPoint>
    implements ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues values;

        public GeoPoints(MultiGeoPointValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public GeoPoint getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return null;
            }
            return this.values.valueAt(0);
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            List<GeoPoint> points = this.getValues();
            double[] lats = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lats[i] = points.get(i).lat();
            }
            return lats;
        }

        public double[] getLons() {
            List<GeoPoint> points = this.getValues();
            double[] lons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lons[i] = points.get(i).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public List<GeoPoint> getValues() {
            return Collections.unmodifiableList(this);
        }

        @Override
        public GeoPoint get(int index) {
            GeoPoint point = this.values.valueAt(index);
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.values.count();
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), GeoHashUtils.decodeLatitude(geohash), GeoHashUtils.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }

    public static class Doubles
    extends AbstractList<Double>
    implements ScriptDocValues<Double> {
        private final SortedNumericDoubleValues values;

        public Doubles(SortedNumericDoubleValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.values;
        }

        public double getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return 0.0;
            }
            return this.values.valueAt(0);
        }

        @Override
        public List<Double> getValues() {
            return Collections.unmodifiableList(this);
        }

        @Override
        public Double get(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static class Longs
    extends AbstractList<Long>
    implements ScriptDocValues<Long> {
        private final SortedNumericDocValues values;
        private final MutableDateTime date = new MutableDateTime(0L, DateTimeZone.UTC);

        public Longs(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedNumericDocValues getInternalValues() {
            return this.values;
        }

        public long getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return 0L;
            }
            return this.values.valueAt(0);
        }

        @Override
        public List<Long> getValues() {
            return Collections.unmodifiableList(this);
        }

        public ReadableDateTime getDate() {
            this.date.setMillis(this.getValue());
            return this.date;
        }

        @Override
        public Long get(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static final class Strings
    extends AbstractList<String>
    implements ScriptDocValues<String> {
        private final SortedBinaryDocValues values;

        public Strings(SortedBinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedBinaryDocValues getInternalValues() {
            return this.values;
        }

        public BytesRef getBytesValue() {
            if (this.values.count() > 0) {
                return this.values.valueAt(0);
            }
            return null;
        }

        public String getValue() {
            BytesRef value = this.getBytesValue();
            if (value == null) {
                return null;
            }
            return value.utf8ToString();
        }

        @Override
        public List<String> getValues() {
            return Collections.unmodifiableList(this);
        }

        @Override
        public String get(int index) {
            return this.values.valueAt(index).utf8ToString();
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }
}

