/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.DistributionLL;
import org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.LambdaDF;
import org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.AbstractSimilarityProvider;

public class IBSimilarityProvider
extends AbstractSimilarityProvider {
    private static final Map<String, Distribution> DISTRIBUTIONS;
    private static final Map<String, Lambda> LAMBDAS;
    private final IBSimilarity similarity;

    public IBSimilarityProvider(String name, Settings settings) {
        super(name);
        Distribution distribution = this.parseDistribution(settings);
        Lambda lambda = this.parseLambda(settings);
        Normalization normalization = this.parseNormalization(settings);
        this.similarity = new IBSimilarity(distribution, lambda, normalization);
    }

    protected Distribution parseDistribution(Settings settings) {
        String rawDistribution = settings.get("distribution");
        Distribution distribution = DISTRIBUTIONS.get(rawDistribution);
        if (distribution == null) {
            throw new IllegalArgumentException("Unsupported Distribution [" + rawDistribution + "]");
        }
        return distribution;
    }

    protected Lambda parseLambda(Settings settings) {
        String rawLambda = settings.get("lambda");
        Lambda lambda = LAMBDAS.get(rawLambda);
        if (lambda == null) {
            throw new IllegalArgumentException("Unsupported Lambda [" + rawLambda + "]");
        }
        return lambda;
    }

    @Override
    public Similarity get() {
        return this.similarity;
    }

    static {
        HashMap<String, Object> distributions = new HashMap<String, Object>();
        distributions.put("ll", new DistributionLL());
        distributions.put("spl", new DistributionSPL());
        DISTRIBUTIONS = Collections.unmodifiableMap(distributions);
        HashMap<String, Object> lamdas = new HashMap<String, Object>();
        lamdas.put("df", new LambdaDF());
        lamdas.put("ttf", new LambdaTTF());
        LAMBDAS = Collections.unmodifiableMap(lamdas);
    }
}

