/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.indices.IndicesRequestCache;

abstract class AbstractIndexShardCacheEntity
implements IndicesRequestCache.CacheEntity {
    private final Loader loader;
    private boolean loadedFromCache = true;

    protected AbstractIndexShardCacheEntity(Loader loader) {
        this.loader = loader;
    }

    public final boolean loadedFromCache() {
        return this.loadedFromCache;
    }

    protected abstract ShardRequestCache stats();

    @Override
    public final IndicesRequestCache.Value loadValue() throws IOException {
        int expectedSizeInBytes = 512;
        try (BytesStreamOutput out = new BytesStreamOutput(512);){
            this.loader.load(out);
            BytesReference reference = out.bytes();
            this.loadedFromCache = false;
            IndicesRequestCache.Value value = new IndicesRequestCache.Value(reference, out.ramBytesUsed());
            return value;
        }
    }

    @Override
    public final void onCached(IndicesRequestCache.Key key, IndicesRequestCache.Value value) {
        this.stats().onCached(key, value);
    }

    @Override
    public final void onHit() {
        this.stats().onHit();
    }

    @Override
    public final void onMiss() {
        this.stats().onMiss();
    }

    @Override
    public final void onRemoval(RemovalNotification<IndicesRequestCache.Key, IndicesRequestCache.Value> notification) {
        this.stats().onRemoval(notification.getKey(), notification.getValue(), notification.getRemovalReason() == RemovalNotification.RemovalReason.EVICTED);
    }

    @FunctionalInterface
    public static interface Loader {
        public void load(StreamOutput var1) throws IOException;
    }
}

