/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.transport.netty3.ChannelBufferBytesReference;
import org.elasticsearch.transport.netty3.Netty3InternalESLogger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;

public class Netty3Utils {
    public static final boolean DEFAULT_GATHERING = true;
    private static EsThreadNameDeterminer ES_THREAD_NAME_DETERMINER = new EsThreadNameDeterminer();

    public static void setup() {
    }

    public static ChannelBuffer toChannelBuffer(BytesReference reference) {
        if (reference.length() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (reference instanceof ChannelBufferBytesReference) {
            return ((ChannelBufferBytesReference)reference).toChannelBuffer();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ChannelBuffer> buffers = new ArrayList<ChannelBuffer>();
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(ChannelBuffers.wrappedBuffer((byte[])slice.bytes, (int)slice.offset, (int)slice.length));
            }
            return ChannelBuffers.wrappedBuffer((boolean)true, (ChannelBuffer[])buffers.toArray(new ChannelBuffer[buffers.size()]));
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ChannelBuffer channelBuffer) {
        return Netty3Utils.toBytesReference(channelBuffer, channelBuffer.readableBytes());
    }

    public static BytesReference toBytesReference(ChannelBuffer channelBuffer, int size) {
        return new ChannelBufferBytesReference(channelBuffer, size);
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new InternalLoggerFactory(){

            public InternalLogger newInstance(String name) {
                name = name.replace("org.jboss.netty.", "netty3.").replace("org.jboss.netty.", "netty3.");
                return new Netty3InternalESLogger(Loggers.getLogger((String)name));
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ES_THREAD_NAME_DETERMINER);
        String key = "sun.nio.ch.bugLevel";
        String buglevel = System.getProperty("sun.nio.ch.bugLevel");
        if (buglevel == null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    @SuppressForbidden(reason="to use System#setProperty to set sun.nio.ch.bugLevel")
                    public Void run() {
                        System.setProperty("sun.nio.ch.bugLevel", "");
                        return null;
                    }
                });
            }
            catch (SecurityException e) {
                Loggers.getLogger(Netty3Utils.class).debug(() -> new ParameterizedMessage("Unable to get/set System Property: {}", (Object)"sun.nio.ch.bugLevel"), (Throwable)e);
            }
        }
    }

    public static class EsThreadNameDeterminer
    implements ThreadNameDeterminer {
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return currentThreadName + "{" + proposedThreadName + "}";
        }
    }
}

