/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermQueryConstantScoreWrapper;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.SloppyMath;

abstract class GeoPointMultiTermQuery
extends MultiTermQuery {
    protected final double minLon;
    protected final long minEncoded;
    protected final int minX;
    protected final double minLat;
    protected final int minY;
    protected final double maxLon;
    protected final int maxX;
    protected final double maxLat;
    protected final int maxY;
    protected final short maxShift;
    protected final GeoPointField.TermEncoding termEncoding;
    protected final CellComparator cellComparator;
    public static final MultiTermQuery.RewriteMethod GEO_CONSTANT_SCORE_REWRITE = new MultiTermQuery.RewriteMethod(){

        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new GeoPointTermQueryConstantScoreWrapper<GeoPointMultiTermQuery>((GeoPointMultiTermQuery)query);
        }
    };

    public GeoPointMultiTermQuery(String field, GeoPointField.TermEncoding termEncoding, double minLat, double maxLat, double minLon, double maxLon) {
        super(field);
        this.minEncoded = GeoPointField.encodeLatLon(minLat, minLon);
        long maxEncoded = GeoPointField.encodeLatLon(maxLat, maxLon);
        this.minX = (int)BitUtil.deinterleave((long)this.minEncoded);
        this.maxX = (int)BitUtil.deinterleave((long)maxEncoded);
        this.minY = (int)BitUtil.deinterleave((long)(this.minEncoded >>> 1));
        this.maxY = (int)BitUtil.deinterleave((long)(maxEncoded >>> 1));
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.maxShift = this.computeMaxShift();
        this.termEncoding = termEncoding;
        this.cellComparator = this.newCellComparator();
        this.rewriteMethod = GEO_CONSTANT_SCORE_REWRITE;
    }

    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return GeoPointTermsEnum.newInstance(terms.iterator(), this);
    }

    protected short computeMaxShift() {
        double midLat = (this.minLat + this.maxLat) * 0.5;
        double midLon = (this.minLon + this.maxLon) * 0.5;
        int shiftFactor = SloppyMath.haversinMeters((double)this.minLat, (double)this.minLon, (double)midLat, (double)midLon) > 1000000.0 ? 5 : 4;
        return (short)(9 * shiftFactor);
    }

    protected abstract CellComparator newCellComparator();

    static abstract class CellComparator {
        protected final GeoPointMultiTermQuery geoPointQuery;

        CellComparator(GeoPointMultiTermQuery query) {
            this.geoPointQuery = query;
        }

        protected boolean cellIntersectsMBR(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectIntersects(minLat, maxLat, minLon, maxLon, this.geoPointQuery.minLat, this.geoPointQuery.maxLat, this.geoPointQuery.minLon, this.geoPointQuery.maxLon);
        }

        protected boolean cellIntersectsMBR(long min, long max) {
            return Integer.compareUnsigned((int)BitUtil.deinterleave((long)max), this.geoPointQuery.minX) >= 0 && Integer.compareUnsigned((int)BitUtil.deinterleave((long)min), this.geoPointQuery.maxX) <= 0 && Integer.compareUnsigned((int)BitUtil.deinterleave((long)(max >>> 1)), this.geoPointQuery.minY) >= 0 && Integer.compareUnsigned((int)BitUtil.deinterleave((long)(min >>> 1)), this.geoPointQuery.maxY) <= 0;
        }

        protected boolean cellContains(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectWithin(this.geoPointQuery.minLat, this.geoPointQuery.maxLat, this.geoPointQuery.minLon, this.geoPointQuery.maxLon, minLat, maxLat, minLon, maxLon);
        }

        protected abstract boolean cellCrosses(double var1, double var3, double var5, double var7);

        protected abstract boolean cellWithin(double var1, double var3, double var5, double var7);

        protected abstract boolean cellIntersectsShape(double var1, double var3, double var5, double var7);

        protected abstract PointValues.Relation relate(double var1, double var3, double var5, double var7);

        protected abstract boolean postFilter(double var1, double var3);
    }
}

