/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.RealizableTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskReferenceResolver;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskReference;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Transformers;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final MutableModelNode modelNode;
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private final Set<String> placeholders = Sets.newHashSet();
    private final NamedEntityInstantiator<Task> instantiator;

    public DefaultTaskContainer(MutableModelNode modelNode, ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener) {
        super(Task.class, instantiator, project);
        this.modelNode = modelNode;
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
        this.instantiator = new TaskInstantiator(taskFactory);
    }

    @Override
    public Task create(Map<String, ?> options) {
        Task existing;
        HashMap mutableOptions = new HashMap(options);
        Object replaceStr = mutableOptions.remove("overwrite");
        boolean replace = replaceStr != null && "true".equals(replaceStr.toString());
        TaskInternal task = this.taskFactory.createTask(mutableOptions);
        String name = task.getName();
        if (this.placeholders.remove(name)) {
            this.modelNode.removeLink(name);
        }
        if ((existing = (Task)this.findByNameWithoutRules(name)) != null) {
            if (replace) {
                this.remove(existing);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
            }
        }
        this.add(task);
        return task;
    }

    @Override
    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return (U)this.create(name, (Class)type);
    }

    @Override
    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map((Object[])new Object[]{"name", name, "type", type}))));
    }

    @Override
    public Task create(String name) {
        return this.create(GUtil.map((Object[])new Object[]{"name", name}));
    }

    @Override
    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    @Override
    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    @Override
    public Task replace(String name) {
        return this.create(GUtil.map((Object[])new Object[]{"name", name, "overwrite", true}));
    }

    @Override
    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    @Override
    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        Object task = this.create(name, (Class)type);
        configuration.execute(task);
        return (T)task;
    }

    @Override
    public <T extends Task> T replace(String name, Class<T> type) {
        return (T)((Task)type.cast(this.create(GUtil.map((Object[])new Object[]{"name", name, "type", type, "overwrite", true}))));
    }

    @Override
    public Task findByPath(String path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(!GUtil.isTrue((Object)projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(String path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path);
    }

    @Override
    public Task resolveTask(TaskReference reference) {
        for (TaskReferenceResolver taskResolver : this.project.getServices().getAll(TaskReferenceResolver.class)) {
            Task constructed = taskResolver.constructTask(reference, this);
            if (constructed == null) continue;
            return constructed;
        }
        throw new UnknownTaskException(String.format("Task reference '%s' could not be resolved in %s.", reference.getName(), this.project));
    }

    @Override
    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        return ConfigureUtil.configureSelf(configureClosure, this, new NamedDomainObjectContainerConfigureDelegate(configureClosure, this));
    }

    @Override
    public NamedEntityInstantiator<Task> getEntityInstantiator() {
        return this.instantiator;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        return Sets.newTreeSet((Iterable)this.modelNode.getLinkNames());
    }

    @Override
    public void realize() {
        this.project.getModelRegistry().realizeNode(this.modelNode.getPath());
        new CachingDirectedGraphWalker<Task, Void>(new DirectedGraph<Task, Void>(){

            @Override
            public void getNodeValues(Task node, Collection<? super Void> values, Collection<? super Task> connectedNodes) {
                connectedNodes.addAll(node.getTaskDependencies().getDependencies(node));
            }
        }).add(this).findValues();
    }

    @Override
    public void discoverTasks() {
        this.project.fireDeferredConfiguration();
        this.project.getModelRegistry().atStateOrLater(this.modelNode.getPath(), ModelNode.State.SelfClosed);
    }

    @Override
    public void prepareForExecution(Task task) {
        assert (task.getProject() == this.project);
        if (this.modelNode.hasLink(task.getName())) {
            this.realizeTask(MODEL_PATH.child(task.getName()), ModelNode.State.GraphClosed);
        }
    }

    private void maybeCreateTasks(String name) {
        if (this.modelNode.hasLink(name)) {
            this.realizeTask(MODEL_PATH.child(name), ModelNode.State.Initialized);
        }
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        this.maybeCreateTasks(name);
        this.placeholders.remove(name);
        return (Task)super.findByName(name);
    }

    private Task realizeTask(ModelPath taskPath, ModelNode.State minState) {
        return (Task)this.project.getModelRegistry().atStateOrLater(taskPath, ModelType.of(Task.class), minState);
    }

    @Override
    public <T extends TaskInternal> void addPlaceholderAction(String placeholderName, Class<T> taskType, Action<? super T> configure) {
        if (!this.modelNode.hasLink(placeholderName)) {
            ModelType taskModelType = ModelType.of(taskType);
            ModelPath path = MODEL_PATH.child(placeholderName);
            this.modelNode.addLink(ModelRegistrations.of((ModelPath)path).action(ModelActionRole.Create, new TaskCreator<T>(placeholderName, taskType, configure, taskModelType)).withProjection((ModelProjection)new UnmanagedModelProjection(taskModelType)).descriptor((ModelRuleDescriptor)new SimpleModelRuleDescriptor("tasks.addPlaceholderAction(" + placeholderName + ")")).build());
        }
        if (this.findByNameWithoutRules(placeholderName) == null) {
            this.placeholders.add(placeholderName);
        }
    }

    @Override
    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }

    @Override
    public <S extends Task> TaskCollection<S> withType(Class<S> type) {
        return new RealizableTaskCollection<S>(type, super.withType((Class)type), this.modelNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskCreator<T extends TaskInternal>
    implements Action<MutableModelNode> {
        private final String placeholderName;
        private final Class<T> taskType;
        private final Action<? super T> configure;
        private final ModelType<T> taskModelType;

        public TaskCreator(String placeholderName, Class<T> taskType, Action<? super T> configure, ModelType<T> taskModelType) {
            this.placeholderName = placeholderName;
            this.taskType = taskType;
            this.configure = configure;
            this.taskModelType = taskModelType;
        }

        public void execute(MutableModelNode mutableModelNode) {
            DefaultTaskContainer taskContainer = (DefaultTaskContainer)mutableModelNode.getParent().getPrivateData(ModelType.of(DefaultTaskContainer.class));
            TaskInternal task = (TaskInternal)taskContainer.taskFactory.create(this.placeholderName, this.taskType);
            this.configure.execute((Object)task);
            taskContainer.add(task);
            mutableModelNode.setPrivateData(this.taskModelType, (Object)task);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInstantiator
    implements NamedEntityInstantiator<Task> {
        private final ITaskFactory taskFactory;

        public TaskInstantiator(ITaskFactory taskFactory) {
            this.taskFactory = taskFactory;
        }

        public <S extends Task> S create(String name, Class<S> type) {
            if (type.isAssignableFrom(TaskInternal.class)) {
                return (S)((Task)type.cast(this.taskFactory.create(name, TaskInternal.class)));
            }
            return (S)((Task)type.cast(this.taskFactory.create(name, type.asSubclass(TaskInternal.class))));
        }
    }
}

