/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.Font;
import javax.swing.plaf.UIResource;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;

public class JBFont
extends Font {
    private JBFont(Font font) {
        super(font);
    }

    public static JBFont create(Font font) {
        return JBFont.create(font, true);
    }

    public static JBFont create(Font font, boolean tryToScale) {
        if (font instanceof JBFont) {
            return (JBFont)font;
        }
        Font scaled = font;
        if (tryToScale) {
            scaled = font.deriveFont((float)font.getSize() * JBUI.scale(1.0f));
        }
        if (font instanceof UIResource) {
            return new JBFontUIResource(scaled);
        }
        return new JBFont(scaled);
    }

    @Override
    public JBFont deriveFont(int style, float size) {
        return JBFont.create(super.deriveFont(style, size), false);
    }

    @Override
    public JBFont deriveFont(float size) {
        return JBFont.create(super.deriveFont(size), false);
    }

    private static class JBFontUIResource
    extends JBFont
    implements UIResource {
        private JBFontUIResource(Font font) {
            super(font);
        }
    }
}

